/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestObjectGet {
    public static final String CONTENT = "0123456789";

    @Test
    public void get() throws IOException, OS3Exception {
        OzoneClientStub client = new OzoneClientStub();
        client.getObjectStore().createS3Bucket("bilbo", "b1");
        String volumeName = client.getObjectStore().getOzoneVolumeName("b1");
        OzoneVolume volume = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = volume.getBucket("b1");
        OzoneOutputStream keyStream = bucket.createKey("key1", (long)CONTENT.getBytes(StandardCharsets.UTF_8).length);
        keyStream.write(CONTENT.getBytes(StandardCharsets.UTF_8));
        keyStream.close();
        ObjectEndpoint rest = new ObjectEndpoint();
        rest.setClient((OzoneClient)client);
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        rest.setHeaders(headers);
        ByteArrayInputStream body = new ByteArrayInputStream(CONTENT.getBytes(StandardCharsets.UTF_8));
        Response response = rest.get("b1", "key1", null, 0, null, (InputStream)body);
        OzoneInputStream ozoneInputStream = volume.getBucket("b1").readKey("key1");
        String keyContent = IOUtils.toString((InputStream)ozoneInputStream, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((Object)CONTENT, (Object)keyContent);
        Assert.assertEquals((Object)("" + keyContent.length()), (Object)response.getHeaderString("Content-Length"));
        DateTimeFormatter.RFC_1123_DATE_TIME.parse(response.getHeaderString("Last-Modified"));
    }
}

