/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadRequest;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadResponse;
import org.apache.hadoop.ozone.s3.endpoint.CopyPartResult;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMultipartUploadWithCopy {
    private static final ObjectEndpoint REST = new ObjectEndpoint();
    private static final String KEY = "key2";
    private static final String EXISTING_KEY = "key1";
    private static final String EXISTING_KEY_CONTENT = "testkey";
    private static final OzoneClientStub CLIENT = new OzoneClientStub();
    private static final int RANGE_FROM = 2;
    private static final int RANGE_TO = 4;

    @BeforeClass
    public static void setUp() throws Exception {
        ObjectStore objectStore = CLIENT.getObjectStore();
        objectStore.createS3Bucket("ozone", "s3Bucket");
        OzoneBucket bucket = TestMultipartUploadWithCopy.getOzoneBucket(objectStore, "s3Bucket");
        byte[] keyContent = EXISTING_KEY_CONTENT.getBytes();
        try (OzoneOutputStream stream = bucket.createKey(EXISTING_KEY, (long)keyContent.length, ReplicationType.RATIS, ReplicationFactor.THREE, new HashMap());){
            stream.write(keyContent);
        }
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"STANDARD");
        REST.setHeaders(headers);
        REST.setClient((OzoneClient)CLIENT);
    }

    @Test
    public void testMultipart() throws Exception {
        String uploadID = this.initiateMultipartUpload(KEY);
        ArrayList<CompleteMultipartUploadRequest.Part> partsList = new ArrayList<CompleteMultipartUploadRequest.Part>();
        String content = "Multipart Upload 1";
        int partNumber = 1;
        CompleteMultipartUploadRequest.Part part1 = this.uploadPart(KEY, uploadID, partNumber, content);
        partsList.add(part1);
        partNumber = 2;
        CompleteMultipartUploadRequest.Part part2 = this.uploadPartWithCopy(KEY, uploadID, partNumber, "s3Bucket/key1", null);
        partsList.add(part2);
        partNumber = 3;
        CompleteMultipartUploadRequest.Part part3 = this.uploadPartWithCopy(KEY, uploadID, partNumber, "s3Bucket/key1", "bytes=2-4");
        partsList.add(part3);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest();
        completeMultipartUploadRequest.setPartList(partsList);
        this.completeMultipartUpload(KEY, completeMultipartUploadRequest, uploadID);
        OzoneBucket bucket = TestMultipartUploadWithCopy.getOzoneBucket(CLIENT.getObjectStore(), "s3Bucket");
        try (OzoneInputStream is = bucket.readKey(KEY);){
            String keyContent = new Scanner((InputStream)is).useDelimiter("\\A").next();
            Assert.assertEquals((Object)(content + EXISTING_KEY_CONTENT + EXISTING_KEY_CONTENT.substring(2, 4)), (Object)keyContent);
        }
    }

    private String initiateMultipartUpload(String key) throws IOException, OS3Exception {
        this.setHeaders();
        Response response = REST.initializeMultipartUpload("s3Bucket", key);
        MultipartUploadInitiateResponse multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        String uploadID = multipartUploadInitiateResponse.getUploadID();
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        return uploadID;
    }

    private CompleteMultipartUploadRequest.Part uploadPart(String key, String uploadID, int partNumber, String content) throws IOException, OS3Exception {
        this.setHeaders();
        ByteArrayInputStream body = new ByteArrayInputStream(content.getBytes());
        Response response = REST.put("s3Bucket", key, (long)content.length(), partNumber, uploadID, (InputStream)body);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
        CompleteMultipartUploadRequest.Part part = new CompleteMultipartUploadRequest.Part();
        part.seteTag(response.getHeaderString("ETag"));
        part.setPartNumber(partNumber);
        return part;
    }

    private CompleteMultipartUploadRequest.Part uploadPartWithCopy(String key, String uploadID, int partNumber, String keyOrigin, String range) throws IOException, OS3Exception {
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("x-amz-copy-source", keyOrigin);
        if (range != null) {
            additionalHeaders.put("x-amz-copy-source-range", range);
        }
        this.setHeaders(additionalHeaders);
        ByteArrayInputStream body = new ByteArrayInputStream("".getBytes());
        Response response = REST.put("s3Bucket", key, 0L, partNumber, uploadID, (InputStream)body);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        CopyPartResult result = (CopyPartResult)response.getEntity();
        Assert.assertNotNull((Object)result.getETag());
        Assert.assertNotNull((Object)result.getLastModified());
        CompleteMultipartUploadRequest.Part part = new CompleteMultipartUploadRequest.Part();
        part.seteTag(result.getETag());
        part.setPartNumber(partNumber);
        return part;
    }

    private void completeMultipartUpload(String key, CompleteMultipartUploadRequest completeMultipartUploadRequest, String uploadID) throws IOException, OS3Exception {
        this.setHeaders();
        Response response = REST.completeMultipartUpload("s3Bucket", key, uploadID, completeMultipartUploadRequest);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        CompleteMultipartUploadResponse completeMultipartUploadResponse = (CompleteMultipartUploadResponse)response.getEntity();
        Assert.assertEquals((Object)completeMultipartUploadResponse.getBucket(), (Object)"s3Bucket");
        Assert.assertEquals((Object)completeMultipartUploadResponse.getKey(), (Object)KEY);
        Assert.assertEquals((Object)completeMultipartUploadResponse.getLocation(), (Object)"s3Bucket");
        Assert.assertNotNull((Object)completeMultipartUploadResponse.getETag());
    }

    private void setHeaders(Map<String, String> additionalHeaders) {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"STANDARD");
        additionalHeaders.forEach((k, v) -> Mockito.when((Object)headers.getHeaderString(k)).thenReturn(v));
        REST.setHeaders(headers);
    }

    private void setHeaders() {
        this.setHeaders(new HashMap<String, String>());
    }

    private static OzoneBucket getOzoneBucket(ObjectStore objectStore, String bucketName) throws IOException {
        String ozoneBucketName = objectStore.getOzoneBucketName(bucketName);
        String ozoneVolumeName = objectStore.getOzoneVolumeName(bucketName);
        return objectStore.getVolume(ozoneVolumeName).getBucket(ozoneBucketName);
    }
}

