/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadRequest;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadResponse;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMultipartUploadComplete {
    private static final ObjectEndpoint REST = new ObjectEndpoint();
    private static final OzoneClientStub CLIENT = new OzoneClientStub();

    @BeforeClass
    public static void setUp() throws Exception {
        CLIENT.getObjectStore().createS3Bucket("ozone", "s3Bucket");
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"STANDARD");
        REST.setHeaders(headers);
        REST.setClient((OzoneClient)CLIENT);
    }

    private String initiateMultipartUpload(String key) throws IOException, OS3Exception {
        Response response = REST.initializeMultipartUpload("s3Bucket", key);
        MultipartUploadInitiateResponse multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        String uploadID = multipartUploadInitiateResponse.getUploadID();
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        return uploadID;
    }

    private CompleteMultipartUploadRequest.Part uploadPart(String key, String uploadID, int partNumber, String content) throws IOException, OS3Exception {
        ByteArrayInputStream body = new ByteArrayInputStream(content.getBytes());
        Response response = REST.put("s3Bucket", key, (long)content.length(), partNumber, uploadID, (InputStream)body);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
        CompleteMultipartUploadRequest.Part part = new CompleteMultipartUploadRequest.Part();
        part.seteTag(response.getHeaderString("ETag"));
        part.setPartNumber(partNumber);
        return part;
    }

    private void completeMultipartUpload(String key, CompleteMultipartUploadRequest completeMultipartUploadRequest, String uploadID) throws IOException, OS3Exception {
        Response response = REST.completeMultipartUpload("s3Bucket", key, uploadID, completeMultipartUploadRequest);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        CompleteMultipartUploadResponse completeMultipartUploadResponse = (CompleteMultipartUploadResponse)response.getEntity();
        Assert.assertEquals((Object)completeMultipartUploadResponse.getBucket(), (Object)"s3Bucket");
        Assert.assertEquals((Object)completeMultipartUploadResponse.getKey(), (Object)key);
        Assert.assertEquals((Object)completeMultipartUploadResponse.getLocation(), (Object)"s3Bucket");
        Assert.assertNotNull((Object)completeMultipartUploadResponse.getETag());
    }

    @Test
    public void testMultipart() throws Exception {
        String uploadID = this.initiateMultipartUpload("key");
        ArrayList<CompleteMultipartUploadRequest.Part> partsList = new ArrayList<CompleteMultipartUploadRequest.Part>();
        String content = "Multipart Upload 1";
        int partNumber = 1;
        CompleteMultipartUploadRequest.Part part1 = this.uploadPart("key", uploadID, partNumber, content);
        partsList.add(part1);
        content = "Multipart Upload 2";
        partNumber = 2;
        CompleteMultipartUploadRequest.Part part2 = this.uploadPart("key", uploadID, partNumber, content);
        partsList.add(part2);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest();
        completeMultipartUploadRequest.setPartList(partsList);
        this.completeMultipartUpload("key", completeMultipartUploadRequest, uploadID);
    }

    @Test
    public void testMultipartInvalidPartOrderError() throws Exception {
        String key = UUID.randomUUID().toString();
        String uploadID = this.initiateMultipartUpload(key);
        ArrayList<CompleteMultipartUploadRequest.Part> partsList = new ArrayList<CompleteMultipartUploadRequest.Part>();
        String content = "Multipart Upload 1";
        int partNumber = 1;
        CompleteMultipartUploadRequest.Part part1 = this.uploadPart(key, uploadID, partNumber, content);
        part1.setPartNumber(3);
        partsList.add(part1);
        content = "Multipart Upload 2";
        partNumber = 2;
        CompleteMultipartUploadRequest.Part part2 = this.uploadPart(key, uploadID, partNumber, content);
        partsList.add(part2);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest();
        completeMultipartUploadRequest.setPartList(partsList);
        try {
            this.completeMultipartUpload(key, completeMultipartUploadRequest, uploadID);
            Assert.fail((String)"testMultipartInvalidPartOrderError");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)S3ErrorTable.INVALID_PART_ORDER.getCode(), (Object)ex.getCode());
        }
    }

    @Test
    public void testMultipartInvalidPartError() throws Exception {
        String key = UUID.randomUUID().toString();
        String uploadID = this.initiateMultipartUpload(key);
        ArrayList<CompleteMultipartUploadRequest.Part> partsList = new ArrayList<CompleteMultipartUploadRequest.Part>();
        String content = "Multipart Upload 1";
        int partNumber = 1;
        CompleteMultipartUploadRequest.Part part1 = this.uploadPart(key, uploadID, partNumber, content);
        part1.seteTag("random");
        partsList.add(part1);
        content = "Multipart Upload 2";
        partNumber = 2;
        CompleteMultipartUploadRequest.Part part2 = this.uploadPart(key, uploadID, partNumber, content);
        partsList.add(part2);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest();
        completeMultipartUploadRequest.setPartList(partsList);
        try {
            this.completeMultipartUpload(key, completeMultipartUploadRequest, uploadID);
            Assert.fail((String)"testMultipartInvalidPartError");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)ex.getCode(), (Object)S3ErrorTable.INVALID_PART.getCode());
        }
    }
}

