/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteRequest;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteRequestUnmarshaller;
import org.junit.Assert;
import org.junit.Test;

public class TestMultiDeleteRequestUnmarshaller {
    @Test
    public void fromStreamWithNamespace() throws IOException {
        ByteArrayInputStream inputBody = new ByteArrayInputStream("<Delete xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Object>key1</Object><Object>key2</Object><Object>key3</Object></Delete>".getBytes(StandardCharsets.UTF_8));
        MultiDeleteRequest multiDeleteRequest = this.unmarshall(inputBody);
        Assert.assertEquals((long)3L, (long)multiDeleteRequest.getObjects().size());
    }

    @Test
    public void fromStreamWithoutNamespace() throws IOException {
        ByteArrayInputStream inputBody = new ByteArrayInputStream("<Delete><Object>key1</Object><Object>key2</Object><Object>key3</Object></Delete>".getBytes(StandardCharsets.UTF_8));
        MultiDeleteRequest multiDeleteRequest = this.unmarshall(inputBody);
        Assert.assertEquals((long)3L, (long)multiDeleteRequest.getObjects().size());
    }

    private MultiDeleteRequest unmarshall(ByteArrayInputStream inputBody) throws IOException {
        return new MultiDeleteRequestUnmarshaller().readFrom(null, null, null, null, null, (InputStream)inputBody);
    }
}

