/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.endpoint.ListPartsResponse;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestListParts {
    private static final ObjectEndpoint REST = new ObjectEndpoint();
    private static String uploadID;

    @BeforeClass
    public static void setUp() throws Exception {
        OzoneClientStub client = new OzoneClientStub();
        client.getObjectStore().createS3Bucket("ozone", "s3Bucket");
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"STANDARD");
        REST.setHeaders(headers);
        REST.setClient((OzoneClient)client);
        Response response = REST.initializeMultipartUpload("s3Bucket", "key");
        MultipartUploadInitiateResponse multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        uploadID = multipartUploadInitiateResponse.getUploadID();
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        String content = "Multipart Upload";
        ByteArrayInputStream body = new ByteArrayInputStream(content.getBytes());
        response = REST.put("s3Bucket", "key", (long)content.length(), 1, uploadID, (InputStream)body);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
        response = REST.put("s3Bucket", "key", (long)content.length(), 2, uploadID, (InputStream)body);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
        response = REST.put("s3Bucket", "key", (long)content.length(), 3, uploadID, (InputStream)body);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
    }

    @Test
    public void testListParts() throws Exception {
        Response response = REST.get("s3Bucket", "key", uploadID, 3, "0", null);
        ListPartsResponse listPartsResponse = (ListPartsResponse)response.getEntity();
        Assert.assertFalse((boolean)listPartsResponse.getTruncated());
        Assert.assertTrue((listPartsResponse.getPartList().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testListPartsContinuation() throws Exception {
        Response response = REST.get("s3Bucket", "key", uploadID, 2, "0", null);
        ListPartsResponse listPartsResponse = (ListPartsResponse)response.getEntity();
        Assert.assertTrue((boolean)listPartsResponse.getTruncated());
        Assert.assertTrue((listPartsResponse.getPartList().size() == 2 ? 1 : 0) != 0);
        response = REST.get("s3Bucket", "key", uploadID, 2, Integer.toString(listPartsResponse.getNextPartNumberMarker()), null);
        listPartsResponse = (ListPartsResponse)response.getEntity();
        Assert.assertFalse((boolean)listPartsResponse.getTruncated());
        Assert.assertTrue((listPartsResponse.getPartList().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testListPartsWithUnknownUploadID() throws Exception {
        try {
            Response response = REST.get("s3Bucket", "key", uploadID, 2, "0", null);
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)S3ErrorTable.NO_SUCH_UPLOAD.getErrorMessage(), (Object)ex.getErrorMessage());
        }
    }
}

