/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestInitiateMultipartUpload {
    @Test
    public void testInitiateMultipartUpload() throws Exception {
        String bucket = "s3Bucket";
        String key = "key";
        OzoneClientStub client = new OzoneClientStub();
        client.getObjectStore().createS3Bucket("ozone", bucket);
        String volumeName = client.getObjectStore().getOzoneVolumeName(bucket);
        OzoneVolume volume = client.getObjectStore().getVolume(volumeName);
        OzoneBucket ozoneBucket = volume.getBucket("s3Bucket");
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"STANDARD");
        ObjectEndpoint rest = new ObjectEndpoint();
        rest.setHeaders(headers);
        rest.setClient((OzoneClient)client);
        Response response = rest.initializeMultipartUpload(bucket, key);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        MultipartUploadInitiateResponse multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        String uploadID = multipartUploadInitiateResponse.getUploadID();
        response = rest.initializeMultipartUpload(bucket, key);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        Assert.assertNotEquals((Object)multipartUploadInitiateResponse.getUploadID(), (Object)uploadID);
    }
}

