/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.time.LocalDate;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.AWSV4SignatureProcessor;
import org.apache.hadoop.ozone.s3.SignatureProcessor;
import org.apache.hadoop.ozone.s3.endpoint.BucketEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBucketPut {
    private String bucketName = "bucket";
    private OzoneClientStub clientStub;
    private BucketEndpoint bucketEndpoint;

    @Before
    public void setup() throws Exception {
        this.clientStub = new OzoneClientStub();
        this.bucketEndpoint = new BucketEndpoint();
        this.bucketEndpoint.setClient((OzoneClient)this.clientStub);
        this.bucketEndpoint.setSignatureProcessor(new SignatureProcessor(){

            public String getStringToSign() throws Exception {
                return null;
            }

            public String getSignature() {
                return null;
            }

            public String getAwsAccessId() {
                return "ozone";
            }
        });
    }

    @Test
    public void testBucketFailWithAuthHeaderMissing() throws Exception {
        try {
            this.bucketEndpoint.put(this.bucketName, null);
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((long)404L, (long)ex.getHttpCode());
            Assert.assertEquals((Object)S3ErrorTable.MALFORMED_HEADER.getCode(), (Object)ex.getCode());
        }
    }

    @Test
    public void testBucketPut() throws Exception {
        String auth = this.generateAuthHeader();
        Response response = this.bucketEndpoint.put(this.bucketName, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getLocation());
    }

    @Test
    public void testBucketFailWithInvalidHeader() throws Exception {
        try {
            this.bucketEndpoint.put(this.bucketName, null);
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((long)404L, (long)ex.getHttpCode());
            Assert.assertEquals((Object)S3ErrorTable.MALFORMED_HEADER.getCode(), (Object)ex.getCode());
        }
    }

    private String generateAuthHeader() {
        LocalDate now = LocalDate.now();
        String curDate = AWSV4SignatureProcessor.DATE_FORMATTER.format(now);
        return "AWS4-HMAC-SHA256 Credential=ozone/" + curDate + "/us-east-1/s3/aws4_request, SignedHeaders=host;range;x-amz-date, Signature=fe5f80f77d5fa3beca038a248ff027";
    }
}

