/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.endpoint.BucketEndpoint;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBucketHead {
    private String bucketName = "bucket";
    private String userName = "ozone";
    private OzoneClientStub clientStub;
    private ObjectStore objectStoreStub;
    private BucketEndpoint bucketEndpoint;

    @Before
    public void setup() throws Exception {
        this.clientStub = new OzoneClientStub();
        this.objectStoreStub = this.clientStub.getObjectStore();
        this.objectStoreStub.createS3Bucket(this.userName, this.bucketName);
        this.bucketEndpoint = new BucketEndpoint();
        this.bucketEndpoint.setClient((OzoneClient)this.clientStub);
    }

    @Test
    public void testHeadBucket() throws Exception {
        Response response = this.bucketEndpoint.head(this.bucketName);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testHeadFail() throws Exception {
        Response response = this.bucketEndpoint.head("unknownbucket");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }
}

