/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.commontypes.CommonPrefix;
import org.apache.hadoop.ozone.s3.commontypes.KeyMetadata;
import org.apache.hadoop.ozone.s3.endpoint.BucketEndpoint;
import org.apache.hadoop.ozone.s3.endpoint.ListObjectResponse;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.junit.Assert;
import org.junit.Test;

public class TestBucketGet {
    @Test
    public void listRoot() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient client = this.createClientWithKeys("file1", "dir1/file2");
        getBucket.setClient(client);
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, 100, "", null, null, null, null, null).getEntity();
        Assert.assertEquals((long)1L, (long)getBucketResponse.getCommonPrefixes().size());
        Assert.assertEquals((Object)"dir1/", (Object)((CommonPrefix)getBucketResponse.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((long)1L, (long)getBucketResponse.getContents().size());
        Assert.assertEquals((Object)"file1", (Object)((KeyMetadata)getBucketResponse.getContents().get(0)).getKey());
    }

    @Test
    public void listDir() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient client = this.createClientWithKeys("dir1/file2", "dir1/dir2/file2");
        getBucket.setClient(client);
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, 100, "dir1", null, null, null, null, null).getEntity();
        Assert.assertEquals((long)1L, (long)getBucketResponse.getCommonPrefixes().size());
        Assert.assertEquals((Object)"dir1/", (Object)((CommonPrefix)getBucketResponse.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((long)0L, (long)getBucketResponse.getContents().size());
    }

    @Test
    public void listSubDir() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file2", "dir1/dir2/file2", "dir1bh/file", "dir1bha/file2");
        getBucket.setClient(ozoneClient);
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, 100, "dir1/", null, null, null, null, null).getEntity();
        Assert.assertEquals((long)1L, (long)getBucketResponse.getCommonPrefixes().size());
        Assert.assertEquals((Object)"dir1/dir2/", (Object)((CommonPrefix)getBucketResponse.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((long)1L, (long)getBucketResponse.getContents().size());
        Assert.assertEquals((Object)"dir1/file2", (Object)((KeyMetadata)getBucketResponse.getContents().get(0)).getKey());
    }

    @Test
    public void listWithPrefixAndDelimiter() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file2", "dir1/dir2/file2", "dir1bh/file", "dir1bha/file2", "file2");
        getBucket.setClient(ozoneClient);
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, 100, "dir1", null, null, null, null, null).getEntity();
        Assert.assertEquals((long)3L, (long)getBucketResponse.getCommonPrefixes().size());
    }

    @Test
    public void listWithPrefixAndDelimiter1() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file2", "dir1/dir2/file2", "dir1bh/file", "dir1bha/file2", "file2");
        getBucket.setClient(ozoneClient);
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, 100, "", null, null, null, null, null).getEntity();
        Assert.assertEquals((long)3L, (long)getBucketResponse.getCommonPrefixes().size());
        Assert.assertEquals((Object)"file2", (Object)((KeyMetadata)getBucketResponse.getContents().get(0)).getKey());
    }

    @Test
    public void listWithPrefixAndDelimiter2() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file2", "dir1/dir2/file2", "dir1bh/file", "dir1bha/file2", "file2");
        getBucket.setClient(ozoneClient);
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, 100, "dir1bh", null, null, "dir1/dir2/file2", null, null).getEntity();
        Assert.assertEquals((long)2L, (long)getBucketResponse.getCommonPrefixes().size());
    }

    @Test
    public void listWithContinuationToken() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file2", "dir1/dir2/file2", "dir1bh/file", "dir1bha/file2", "file2");
        getBucket.setClient(ozoneClient);
        int maxKeys = 2;
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", null, null, null, maxKeys, "", null, null, null, null, null).getEntity();
        Assert.assertTrue((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getContents().size() == 2 ? 1 : 0) != 0);
        String continueToken = getBucketResponse.getNextToken();
        getBucketResponse = (ListObjectResponse)getBucket.list("b1", null, null, null, maxKeys, "", null, continueToken, null, null, null).getEntity();
        Assert.assertTrue((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getContents().size() == 2 ? 1 : 0) != 0);
        continueToken = getBucketResponse.getNextToken();
        getBucketResponse = (ListObjectResponse)getBucket.list("b1", null, null, null, maxKeys, "", null, continueToken, null, null, null).getEntity();
        Assert.assertFalse((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getContents().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void listWithContinuationTokenDirBreak() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("test/dir1/file1", "test/dir1/file2", "test/dir1/file3", "test/dir2/file4", "test/dir2/file5", "test/dir2/file6", "test/dir3/file7", "test/file8");
        getBucket.setClient(ozoneClient);
        int maxKeys = 2;
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, maxKeys, "test/", null, null, null, null, null).getEntity();
        Assert.assertEquals((long)0L, (long)getBucketResponse.getContents().size());
        Assert.assertEquals((long)2L, (long)getBucketResponse.getCommonPrefixes().size());
        Assert.assertEquals((Object)"test/dir1/", (Object)((CommonPrefix)getBucketResponse.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"test/dir2/", (Object)((CommonPrefix)getBucketResponse.getCommonPrefixes().get(1)).getPrefix());
        getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, maxKeys, "test/", null, getBucketResponse.getNextToken(), null, null, null).getEntity();
        Assert.assertEquals((long)1L, (long)getBucketResponse.getContents().size());
        Assert.assertEquals((long)1L, (long)getBucketResponse.getCommonPrefixes().size());
        Assert.assertEquals((Object)"test/dir3/", (Object)((CommonPrefix)getBucketResponse.getCommonPrefixes().get(0)).getPrefix());
        Assert.assertEquals((Object)"test/file8", (Object)((KeyMetadata)getBucketResponse.getContents().get(0)).getKey());
    }

    @Test
    public void listWithContinuationToken1() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file1", "dir1bh/file1", "dir1bha/file1", "dir0/file1", "dir2/file1");
        getBucket.setClient(ozoneClient);
        int maxKeys = 2;
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, maxKeys, "dir", null, null, null, null, null).getEntity();
        Assert.assertTrue((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getCommonPrefixes().size() == 2 ? 1 : 0) != 0);
        String continueToken = getBucketResponse.getNextToken();
        getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, maxKeys, "dir", null, continueToken, null, null, null).getEntity();
        Assert.assertTrue((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getCommonPrefixes().size() == 2 ? 1 : 0) != 0);
        continueToken = getBucketResponse.getNextToken();
        getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, maxKeys, "dir", null, continueToken, null, null, null).getEntity();
        Assert.assertFalse((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getCommonPrefixes().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void listWithContinuationTokenFail() throws OS3Exception, IOException {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file2", "dir1/dir2/file2", "dir1bh/file", "dir1bha/file2", "dir1", "dir2", "dir3");
        getBucket.setClient(ozoneClient);
        try {
            ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", "/", null, null, 2, "dir", null, "random", null, null, null).getEntity();
            Assert.fail((String)"listWithContinuationTokenFail");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"random", (Object)ex.getResource());
            Assert.assertEquals((Object)"Invalid Argument", (Object)ex.getErrorMessage());
        }
    }

    @Test
    public void testStartAfter() throws IOException, OS3Exception {
        BucketEndpoint getBucket = new BucketEndpoint();
        OzoneClient ozoneClient = this.createClientWithKeys("dir1/file1", "dir1bh/file1", "dir1bha/file1", "dir0/file1", "dir2/file1");
        getBucket.setClient(ozoneClient);
        ListObjectResponse getBucketResponse = (ListObjectResponse)getBucket.list("b1", null, null, null, 1000, null, null, null, null, null, null).getEntity();
        Assert.assertFalse((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getContents().size() == 5 ? 1 : 0) != 0);
        String startAfter = "dir0/file1";
        getBucketResponse = (ListObjectResponse)getBucket.list("b1", null, null, null, 1000, null, null, null, startAfter, null, null).getEntity();
        Assert.assertFalse((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getContents().size() == 4 ? 1 : 0) != 0);
        getBucketResponse = (ListObjectResponse)getBucket.list("b1", null, null, null, 1000, null, null, null, "random", null, null).getEntity();
        Assert.assertFalse((boolean)getBucketResponse.isTruncated());
        Assert.assertTrue((getBucketResponse.getContents().size() == 0 ? 1 : 0) != 0);
    }

    private OzoneClient createClientWithKeys(String ... keys) throws IOException {
        OzoneClientStub client = new OzoneClientStub();
        client.getObjectStore().createS3Bucket("bilbo", "b1");
        String volume = client.getObjectStore().getOzoneVolumeName("b1");
        client.getObjectStore().getVolume(volume).createBucket("b1");
        OzoneBucket bucket = client.getObjectStore().getVolume(volume).getBucket("b1");
        for (String key : keys) {
            bucket.createKey(key, 0L).close();
        }
        return client;
    }
}

