/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.ObjectStoreStub;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.endpoint.BucketEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBucketDelete {
    private String bucketName = "bucket";
    private OzoneClientStub clientStub;
    private ObjectStore objectStoreStub;
    private BucketEndpoint bucketEndpoint;

    @Before
    public void setup() throws Exception {
        this.clientStub = new OzoneClientStub();
        this.objectStoreStub = this.clientStub.getObjectStore();
        this.objectStoreStub.createS3Bucket("ozone", this.bucketName);
        this.bucketEndpoint = new BucketEndpoint();
        this.bucketEndpoint.setClient((OzoneClient)this.clientStub);
    }

    @Test
    public void testBucketEndpoint() throws Exception {
        Response response = this.bucketEndpoint.delete(this.bucketName);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testDeleteWithNoSuchBucket() throws Exception {
        try {
            this.bucketEndpoint.delete("unknownbucket");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)S3ErrorTable.NO_SUCH_BUCKET.getCode(), (Object)ex.getCode());
            Assert.assertEquals((Object)S3ErrorTable.NO_SUCH_BUCKET.getErrorMessage(), (Object)ex.getErrorMessage());
            return;
        }
        Assert.fail((String)"testDeleteWithNoSuchBucket failed");
    }

    @Test
    public void testDeleteWithBucketNotEmpty() throws Exception {
        try {
            ObjectStoreStub stub = (ObjectStoreStub)this.objectStoreStub;
            stub.setBucketEmptyStatus(this.bucketName, false);
            this.bucketEndpoint.delete(this.bucketName);
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)S3ErrorTable.BUCKET_NOT_EMPTY.getCode(), (Object)ex.getCode());
            Assert.assertEquals((Object)S3ErrorTable.BUCKET_NOT_EMPTY.getErrorMessage(), (Object)ex.getErrorMessage());
            return;
        }
        Assert.fail((String)"testDeleteWithBucketNotEmpty failed");
    }
}

