/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbortMultipartUpload {
    @Test
    public void testAbortMultipartUpload() throws Exception {
        String bucket = "s3Bucket";
        String key = "key";
        OzoneClientStub client = new OzoneClientStub();
        client.getObjectStore().createS3Bucket("ozone", bucket);
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"STANDARD");
        ObjectEndpoint rest = new ObjectEndpoint();
        rest.setHeaders(headers);
        rest.setClient((OzoneClient)client);
        Response response = rest.initializeMultipartUpload(bucket, key);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        MultipartUploadInitiateResponse multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        String uploadID = multipartUploadInitiateResponse.getUploadID();
        response = rest.delete(bucket, key, uploadID);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        try {
            rest.delete(bucket, key, "random");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)S3ErrorTable.NO_SUCH_UPLOAD.getCode(), (Object)ex.getCode());
            Assert.assertEquals((Object)S3ErrorTable.NO_SUCH_UPLOAD.getErrorMessage(), (Object)ex.getErrorMessage());
        }
    }
}

