/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.s3.VirtualHostStyleFilter;
import org.apache.hadoop.test.GenericTestUtils;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ContainerRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestVirtualHostStyleFilter {
    private static OzoneConfiguration conf;
    private static String s3HttpAddr;

    @Before
    public void setup() {
        conf = new OzoneConfiguration();
        s3HttpAddr = "localhost:9878";
        conf.set("ozone.s3g.http-address", s3HttpAddr);
        s3HttpAddr = s3HttpAddr.substring(0, s3HttpAddr.lastIndexOf(":"));
        conf.set("ozone.s3g.domain.name", s3HttpAddr);
    }

    public ContainerRequest createContainerRequest(String host, String path, String queryParams, boolean virtualHostStyle) throws Exception {
        ContainerRequest containerRequest;
        URI baseUri = new URI("http://" + s3HttpAddr);
        URI virtualHostStyleUri = path == null && queryParams == null ? new URI("http://" + s3HttpAddr) : (path != null && queryParams == null ? new URI("http://" + s3HttpAddr + path) : (path != null && queryParams != null ? new URI("http://" + s3HttpAddr + path + queryParams) : new URI("http://" + s3HttpAddr + queryParams)));
        URI pathStyleUri = queryParams == null ? new URI("http://" + s3HttpAddr + path) : new URI("http://" + s3HttpAddr + path + queryParams);
        String httpMethod = "DELETE";
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        PropertiesDelegate propertiesDelegate = (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class);
        if (virtualHostStyle) {
            containerRequest = new ContainerRequest(baseUri, virtualHostStyleUri, httpMethod, securityContext, propertiesDelegate);
            containerRequest.header("Host", (Object)host);
        } else {
            containerRequest = new ContainerRequest(baseUri, pathStyleUri, httpMethod, securityContext, propertiesDelegate);
            containerRequest.header("Host", (Object)host);
        }
        return containerRequest;
    }

    @Test
    public void testVirtualHostStyle() throws Exception {
        VirtualHostStyleFilter virtualHostStyleFilter = new VirtualHostStyleFilter();
        virtualHostStyleFilter.setConfiguration(conf);
        ContainerRequest containerRequest = this.createContainerRequest("mybucket.localhost:9878", "/myfile", null, true);
        virtualHostStyleFilter.filter((ContainerRequestContext)containerRequest);
        URI expected = new URI("http://" + s3HttpAddr + "/mybucket/myfile");
        Assert.assertEquals((Object)expected, (Object)containerRequest.getRequestUri());
    }

    @Test
    public void testPathStyle() throws Exception {
        VirtualHostStyleFilter virtualHostStyleFilter = new VirtualHostStyleFilter();
        virtualHostStyleFilter.setConfiguration(conf);
        ContainerRequest containerRequest = this.createContainerRequest(s3HttpAddr, "/mybucket/myfile", null, false);
        virtualHostStyleFilter.filter((ContainerRequestContext)containerRequest);
        URI expected = new URI("http://" + s3HttpAddr + "/mybucket/myfile");
        Assert.assertEquals((Object)expected, (Object)containerRequest.getRequestUri());
    }

    @Test
    public void testVirtualHostStyleWithCreateBucketRequest() throws Exception {
        VirtualHostStyleFilter virtualHostStyleFilter = new VirtualHostStyleFilter();
        virtualHostStyleFilter.setConfiguration(conf);
        ContainerRequest containerRequest = this.createContainerRequest("mybucket.localhost:9878", null, null, true);
        virtualHostStyleFilter.filter((ContainerRequestContext)containerRequest);
        URI expected = new URI("http://" + s3HttpAddr + "/mybucket");
        Assert.assertEquals((Object)expected, (Object)containerRequest.getRequestUri());
    }

    @Test
    public void testVirtualHostStyleWithQueryParams() throws Exception {
        VirtualHostStyleFilter virtualHostStyleFilter = new VirtualHostStyleFilter();
        virtualHostStyleFilter.setConfiguration(conf);
        ContainerRequest containerRequest = this.createContainerRequest("mybucket.localhost:9878", null, "?prefix=bh", true);
        virtualHostStyleFilter.filter((ContainerRequestContext)containerRequest);
        URI expected = new URI("http://" + s3HttpAddr + "/mybucket?prefix=bh");
        Assert.assertTrue((boolean)expected.toString().contains(containerRequest.getRequestUri().toString()));
        containerRequest = this.createContainerRequest("mybucket.localhost:9878", null, "?prefix=bh&type=dir", true);
        virtualHostStyleFilter.filter((ContainerRequestContext)containerRequest);
        expected = new URI("http://" + s3HttpAddr + "/mybucket?prefix=bh&type=dir");
        Assert.assertTrue((boolean)expected.toString().contains(containerRequest.getRequestUri().toString()));
    }

    @Test
    public void testVirtualHostStyleWithNoMatchingDomain() throws Exception {
        VirtualHostStyleFilter virtualHostStyleFilter = new VirtualHostStyleFilter();
        virtualHostStyleFilter.setConfiguration(conf);
        ContainerRequest containerRequest = this.createContainerRequest("mybucket.myhost:9999", null, null, true);
        try {
            virtualHostStyleFilter.filter((ContainerRequestContext)containerRequest);
            Assert.fail((String)"testVirtualHostStyleWithNoMatchingDomain");
        }
        catch (InvalidRequestException ex) {
            GenericTestUtils.assertExceptionContains((String)"No matching domain", (Throwable)ex);
        }
    }

    @Test
    public void testIncorrectVirtualHostStyle() throws Exception {
        VirtualHostStyleFilter virtualHostStyleFilter = new VirtualHostStyleFilter();
        virtualHostStyleFilter.setConfiguration(conf);
        ContainerRequest containerRequest = this.createContainerRequest("mybucketlocalhost:9878", null, null, true);
        try {
            virtualHostStyleFilter.filter((ContainerRequestContext)containerRequest);
            Assert.fail((String)"testIncorrectVirtualHostStyle failed");
        }
        catch (InvalidRequestException ex) {
            GenericTestUtils.assertExceptionContains((String)"invalid format", (Throwable)ex);
        }
    }
}

