/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.ozone.s3.SignedChunksInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestSignedChunksInputStream {
    @Test
    public void emptyfile() throws IOException {
        InputStream is = this.fileContent("0;chunk-signature=23abb2bd920ddeeaac78a63ed808bc59fa6e7d3ef0e356474b82cdc2f8c93c40");
        String result = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((Object)"", (Object)result);
        is = this.fileContent("0;chunk-signature=23abb2bd920ddeeaac78a63ed808bc59fa6e7d3ef0e356474b82cdc2f8c93c40\r\n");
        result = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void singlechunk() throws IOException {
        InputStream is = this.fileContent("0A;chunk-signature=23abb2bd920ddeeaac78a63ed808bc59fa6e7d3ef0e356474b82cdc2f8c93c40\r\n1234567890\r\n");
        String result = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((Object)"1234567890", (Object)result);
        is = this.fileContent("0A;chunk-signature=23abb2bd920ddeeaac78a63ed808bc59fa6e7d3ef0e356474b82cdc2f8c93c40\r\n1234567890\r\n");
        byte[] bytes = new byte[10];
        IOUtils.read((InputStream)is, (byte[])bytes, (int)0, (int)10);
        Assert.assertEquals((Object)"1234567890", (Object)new String(bytes));
    }

    @Test
    public void singlechunkwithoutend() throws IOException {
        InputStream is = this.fileContent("0A;chunk-signature=23abb2bd920ddeeaac78a63ed808bc59fa6e7d3ef0e356474b82cdc2f8c93c40\r\n1234567890");
        String result = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((Object)"1234567890", (Object)result);
        is = this.fileContent("0A;chunk-signature=23abb2bd920ddeeaac78a63ed808bc59fa6e7d3ef0e356474b82cdc2f8c93c40\r\n1234567890");
        byte[] bytes = new byte[10];
        IOUtils.read((InputStream)is, (byte[])bytes, (int)0, (int)10);
        Assert.assertEquals((Object)"1234567890", (Object)new String(bytes));
    }

    @Test
    public void multichunks() throws IOException {
        InputStream is = this.fileContent("0a;chunk-signature=signature\r\n1234567890\r\n05;chunk-signature=signature\r\nabcde\r\n");
        String result = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((Object)"1234567890abcde", (Object)result);
        is = this.fileContent("0a;chunk-signature=signature\r\n1234567890\r\n05;chunk-signature=signature\r\nabcde\r\n");
        byte[] bytes = new byte[15];
        IOUtils.read((InputStream)is, (byte[])bytes, (int)0, (int)15);
        Assert.assertEquals((Object)"1234567890abcde", (Object)new String(bytes));
    }

    private InputStream fileContent(String content) {
        return new SignedChunksInputStream((InputStream)new ByteArrayInputStream(content.getBytes()));
    }
}

