/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.s3.OzoneClientProducer;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestOzoneClientProducer {
    private OzoneClientProducer producer;
    private MultivaluedMap<String, String> headerMap;
    private MultivaluedMap<String, String> queryMap;
    private String authHeader;
    private String contentMd5;
    private String host;
    private String amzContentSha256;
    private String date;
    private String contentType;
    private ContainerRequestContext context;
    private UriInfo uriInfo;

    public TestOzoneClientProducer(String authHeader, String contentMd5, String host, String amzContentSha256, String date, String contentType) throws Exception {
        this.authHeader = authHeader;
        this.contentMd5 = contentMd5;
        this.host = host;
        this.amzContentSha256 = amzContentSha256;
        this.date = date;
        this.contentType = contentType;
        this.producer = new OzoneClientProducer();
        this.headerMap = new MultivaluedHashMap();
        this.queryMap = new MultivaluedHashMap();
        this.uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        this.context = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        OzoneConfiguration config = new OzoneConfiguration();
        config.setBoolean("ozone.security.enabled", true);
        config.set("ozone.om.address", "");
        this.setupContext();
        this.producer.setOzoneConfiguration(config);
    }

    @Test
    public void testGetClientFailure() throws Exception {
        LambdaTestUtils.intercept(IOException.class, (String)"Couldn't create", () -> this.producer.createClient());
    }

    private void setupContext() throws Exception {
        this.headerMap.putSingle((Object)"Authorization", (Object)this.authHeader);
        this.headerMap.putSingle((Object)"content-md5", (Object)this.contentMd5);
        this.headerMap.putSingle((Object)"Host", (Object)this.host);
        this.headerMap.putSingle((Object)"X-Amz-Content-SHA256", (Object)this.amzContentSha256);
        this.headerMap.putSingle((Object)"X-Amz-Date", (Object)this.date);
        this.headerMap.putSingle((Object)"content-type", (Object)this.contentType);
        Mockito.when((Object)this.uriInfo.getQueryParameters()).thenReturn(this.queryMap);
        Mockito.when((Object)this.uriInfo.getRequestUri()).thenReturn((Object)new URI(""));
        Mockito.when((Object)this.context.getUriInfo()).thenReturn((Object)this.uriInfo);
        Mockito.when((Object)this.context.getHeaders()).thenReturn(this.headerMap);
        Mockito.when((Object)this.context.getHeaderString("Authorization")).thenReturn((Object)this.authHeader);
        Mockito.when((Object)this.context.getUriInfo().getQueryParameters()).thenReturn(this.queryMap);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"AWS4-HMAC-SHA256 Credential=testuser1/20190221/us-west-1/s3/aws4_request, SignedHeaders=content-md5;host;x-amz-content-sha256;x-amz-date, Signature=56ec73ba1974f8feda8365c3caef89c5d4a688d5f9baccf4765f46a14cd745ad", "Zi68x2nPDDXv5qfDC+ZWTg==", "s3g:9878", "e2bd43f11c97cde3465e0e8d1aad77af7ec7aa2ed8e213cd0e241e28375860c6", "20190221T002037Z", ""}, {"AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20150830/us-east-1/iam/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=5d672d79c15b13162d9279b0855cfba6789a8edb4c82c400e06b5924a6f2b5d7", "", "iam.amazonaws.com", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", "20150830T123600Z", "application/x-www-form-urlencoded; charset=utf-8"});
    }
}

