/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.ozone.s3.AWSV4SignatureProcessor;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.header.AuthorizationHeaderV4;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAWSV4SignatureProcessor {
    @Test
    public void testInitialization() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putSingle((Object)"Content-Length", (Object)"123");
        headers.putSingle((Object)"Host", (Object)"0.0.0.0:9878");
        headers.putSingle((Object)"X-AMZ-Content-Sha256", (Object)"Content-SHA");
        headers.putSingle((Object)"X-AMZ-Date", (Object)"123");
        headers.putSingle((Object)"Content-Type", (Object)"ozone/mpu");
        headers.putSingle((Object)"X-Ozone-Original-Content-Type", (Object)"streaming");
        String authHeader = "AWS4-HMAC-SHA256 Credential=AKIAJWFJK62WUTKNFJJA/20181009/us-east-1/s3/aws4_request, SignedHeaders=host;x-amz-content-sha256;x-amz-date;content-type, Signature=db81b057718d7c1b3b8dffa29933099551c51d787b3b13b9e0f9ebed45982bf2";
        headers.putSingle((Object)"Authorization", (Object)authHeader);
        AuthorizationHeaderV4 parserAuthHeader = new AuthorizationHeaderV4(authHeader){

            public void validateDateRange() throws OS3Exception {
            }
        };
        MultivaluedHashMap queryParameters = new MultivaluedHashMap();
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getQueryParameters()).thenReturn((Object)queryParameters);
        Mockito.when((Object)uriInfo.getRequestUri()).thenReturn((Object)new URI("http://localhost/buckets"));
        ContainerRequestContext mock = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)mock.getHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)mock.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)mock.getUriInfo()).thenReturn((Object)uriInfo);
        AWSV4SignatureProcessor parser = new AWSV4SignatureProcessor(){

            void validateSignedHeader(String header, String headerValue) throws OS3Exception {
                super.validateSignedHeader(header, headerValue);
            }
        };
        parser.setV4Header(parserAuthHeader);
        parser.setContext(mock);
        parser.init();
        Assert.assertTrue((String)"the ozone/mpu header is not changed back before signature processing", (boolean)parser.buildCanonicalRequest().contains("content-type:streaming"));
        Assert.assertEquals((String)"String to sign is invalid", (Object)"AWS4-HMAC-SHA256\n123\n20181009/us-east-1/s3/aws4_request\nf20d4de80af2271545385e8d4c7df608cae70a791c69b97aab1527ed93a0d665", (Object)parser.getStringToSign());
    }
}

