/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneBucketStub;
import org.apache.hadoop.ozone.client.OzoneVolume;

public class OzoneVolumeStub
extends OzoneVolume {
    private Map<String, OzoneBucketStub> buckets = new HashMap<String, OzoneBucketStub>();

    public OzoneVolumeStub(String name, String admin, String owner, long quotaInBytes, long creationTime, List<OzoneAcl> acls) {
        super(name, admin, owner, quotaInBytes, creationTime, acls);
    }

    public void createBucket(String bucketName) throws IOException {
        this.createBucket(bucketName, new BucketArgs.Builder().setStorageType(StorageType.DEFAULT).setVersioning(Boolean.valueOf(false)).build());
    }

    public void createBucket(String bucketName, BucketArgs bucketArgs) throws IOException {
        this.buckets.put(bucketName, new OzoneBucketStub(this.getName(), bucketName, bucketArgs.getStorageType(), bucketArgs.getVersioning(), System.currentTimeMillis()));
    }

    public OzoneBucket getBucket(String bucketName) throws IOException {
        if (this.buckets.containsKey(bucketName)) {
            return this.buckets.get(bucketName);
        }
        throw new IOException("BUCKET_NOT_FOUND");
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix) {
        return this.buckets.values().stream().filter(bucket -> {
            if (bucketPrefix != null) {
                return bucket.getName().startsWith(bucketPrefix);
            }
            return true;
        }).collect(Collectors.toList()).iterator();
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix, String prevBucket) {
        return this.buckets.values().stream().filter(bucket -> bucket.getName().compareTo(prevBucket) > 0).filter(bucket -> bucket.getName().startsWith(bucketPrefix)).collect(Collectors.toList()).iterator();
    }

    public void deleteBucket(String bucketName) throws IOException {
        if (!this.buckets.containsKey(bucketName)) {
            throw new IOException("BUCKET_NOT_FOUND");
        }
        this.buckets.remove(bucketName);
    }
}

