/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.OzoneOutputStreamStub;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.util.Time;

public class OzoneBucketStub
extends OzoneBucket {
    private Map<String, OzoneKeyDetails> keyDetails = new HashMap<String, OzoneKeyDetails>();
    private Map<String, byte[]> keyContents = new HashMap<String, byte[]>();
    private Map<String, String> multipartUploadIdMap = new HashMap<String, String>();
    private Map<String, Map<Integer, Part>> partList = new HashMap<String, Map<Integer, Part>>();

    public OzoneBucketStub(String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime) {
        super(volumeName, bucketName, ReplicationFactor.ONE, ReplicationType.STAND_ALONE, storageType, versioning, creationTime);
    }

    public OzoneOutputStream createKey(String key, long size) throws IOException {
        return this.createKey(key, size, ReplicationType.STAND_ALONE, ReplicationFactor.ONE, new HashMap<String, String>());
    }

    public OzoneOutputStream createKey(final String key, final long size, final ReplicationType type, final ReplicationFactor factor, final Map<String, String> metadata) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)size){

            @Override
            public void close() throws IOException {
                OzoneBucketStub.this.keyContents.put(key, this.toByteArray());
                OzoneBucketStub.this.keyDetails.put(key, new OzoneKeyDetails(OzoneBucketStub.this.getVolumeName(), OzoneBucketStub.this.getName(), key, size, System.currentTimeMillis(), System.currentTimeMillis(), new ArrayList(), type, metadata, null, factor.getValue()));
                super.close();
            }
        };
        return new OzoneOutputStream((OutputStream)byteArrayOutputStream);
    }

    public OzoneInputStream readKey(String key) throws IOException {
        return new OzoneInputStream((InputStream)new ByteArrayInputStream(this.keyContents.get(key)));
    }

    public OzoneKeyDetails getKey(String key) throws IOException {
        if (this.keyDetails.containsKey(key)) {
            return this.keyDetails.get(key);
        }
        throw new OMException(OMException.ResultCodes.KEY_NOT_FOUND);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix) {
        TreeMap<String, OzoneKeyDetails> sortedKey = new TreeMap<String, OzoneKeyDetails>(this.keyDetails);
        return sortedKey.values().stream().filter(key -> key.getName().startsWith(keyPrefix)).collect(Collectors.toList()).iterator();
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix, String prevKey) {
        TreeMap<String, OzoneKeyDetails> sortedKey = new TreeMap<String, OzoneKeyDetails>(this.keyDetails);
        return sortedKey.values().stream().filter(key -> key.getName().compareTo(prevKey) > 0).filter(key -> key.getName().startsWith(keyPrefix)).collect(Collectors.toList()).iterator();
    }

    public void deleteKey(String key) throws IOException {
        this.keyDetails.remove(key);
    }

    public void renameKey(String fromKeyName, String toKeyName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationType type, ReplicationFactor factor) throws IOException {
        String uploadID = UUID.randomUUID().toString();
        this.multipartUploadIdMap.put(keyName, uploadID);
        return new OmMultipartInfo(this.getVolumeName(), this.getName(), keyName, uploadID);
    }

    public OzoneOutputStream createMultipartKey(final String key, final long size, final int partNumber, String uploadID) throws IOException {
        String multipartUploadID = this.multipartUploadIdMap.get(key);
        if (multipartUploadID == null || !multipartUploadID.equals(uploadID)) {
            throw new OMException(OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)size){

            @Override
            public void close() throws IOException {
                Part part = new Part(key + size, this.toByteArray());
                if (OzoneBucketStub.this.partList.get(key) == null) {
                    TreeMap<Integer, Part> parts = new TreeMap<Integer, Part>();
                    parts.put(partNumber, part);
                    OzoneBucketStub.this.partList.put(key, parts);
                } else {
                    ((Map)OzoneBucketStub.this.partList.get(key)).put(partNumber, part);
                }
            }
        };
        return new OzoneOutputStreamStub(byteArrayOutputStream, key + size);
    }

    public OmMultipartUploadCompleteInfo completeMultipartUpload(String key, String uploadID, Map<Integer, String> partsMap) throws IOException {
        if (this.multipartUploadIdMap.get(key) == null) {
            throw new OMException(OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        Map<Integer, Part> partsList = this.partList.get(key);
        boolean count = true;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int prevPartNumber = 0;
        for (Map.Entry<Integer, String> part : partsMap.entrySet()) {
            int currentPartNumber = part.getKey();
            if (currentPartNumber <= prevPartNumber) {
                throw new OMException(OMException.ResultCodes.INVALID_PART_ORDER);
            }
            prevPartNumber = currentPartNumber;
        }
        for (Map.Entry<Integer, String> part : partsMap.entrySet()) {
            Part recordedPart = partsList.get(part.getKey());
            if (recordedPart == null || !recordedPart.getPartName().equals(part.getValue())) {
                throw new OMException(OMException.ResultCodes.INVALID_PART);
            }
            output.write(recordedPart.getContent());
            this.keyContents.put(key, output.toByteArray());
        }
        return new OmMultipartUploadCompleteInfo(this.getVolumeName(), this.getName(), key, DigestUtils.sha256Hex((String)key));
    }

    public void abortMultipartUpload(String keyName, String uploadID) throws IOException {
        if (this.multipartUploadIdMap.get(keyName) == null) {
            throw new OMException(OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        this.multipartUploadIdMap.remove(keyName);
    }

    public OzoneMultipartUploadPartListParts listParts(String key, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        if (this.multipartUploadIdMap.get(key) == null) {
            throw new OMException(OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        ArrayList<OzoneMultipartUploadPartListParts.PartInfo> partInfoList = new ArrayList<OzoneMultipartUploadPartListParts.PartInfo>();
        if (this.partList.get(key) == null) {
            return new OzoneMultipartUploadPartListParts(ReplicationType.RATIS, ReplicationFactor.ONE, 0, false);
        }
        Map<Integer, Part> partMap = this.partList.get(key);
        Iterator<Map.Entry<Integer, Part>> partIterator = partMap.entrySet().iterator();
        int count = 0;
        int nextPartNumberMarker = 0;
        boolean truncated = false;
        while (count < maxParts && partIterator.hasNext()) {
            Map.Entry<Integer, Part> partEntry = partIterator.next();
            nextPartNumberMarker = partEntry.getKey();
            if (partEntry.getKey() <= partNumberMarker) continue;
            OzoneMultipartUploadPartListParts.PartInfo partInfo = new OzoneMultipartUploadPartListParts.PartInfo(partEntry.getKey().intValue(), partEntry.getValue().getPartName(), (long)partEntry.getValue().getContent().length, Time.now());
            partInfoList.add(partInfo);
            ++count;
        }
        if (partIterator.hasNext()) {
            truncated = true;
        } else {
            truncated = false;
            nextPartNumberMarker = 0;
        }
        OzoneMultipartUploadPartListParts ozoneMultipartUploadPartListParts = new OzoneMultipartUploadPartListParts(ReplicationType.RATIS, ReplicationFactor.ONE, nextPartNumberMarker, truncated);
        ozoneMultipartUploadPartListParts.addAllParts(partInfoList);
        return ozoneMultipartUploadPartListParts;
    }

    public class Part {
        private String partName;
        private byte[] content;

        public Part(String name, byte[] data) {
            this.partName = name;
            this.content = data;
        }

        public String getPartName() {
            return this.partName;
        }

        public byte[] getContent() {
            return this.content;
        }
    }
}

