/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.OzoneVolumeStub;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.om.exceptions.OMException;

public class ObjectStoreStub
extends ObjectStore {
    private Map<String, OzoneVolumeStub> volumes = new HashMap<String, OzoneVolumeStub>();
    private Map<String, String> bucketVolumeMap = new HashMap<String, String>();
    private Map<String, Boolean> bucketEmptyStatus = new HashMap<String, Boolean>();
    private Map<String, List<OzoneBucket>> userBuckets = new HashMap<String, List<OzoneBucket>>();

    public void createVolume(String volumeName) throws IOException {
        this.createVolume(volumeName, VolumeArgs.newBuilder().setAdmin("root").setOwner("root").setQuota("2147483647").setAcls(new ArrayList()).build());
    }

    public void createVolume(String volumeName, VolumeArgs volumeArgs) throws IOException {
        OzoneVolumeStub volume = new OzoneVolumeStub(volumeName, volumeArgs.getAdmin(), volumeArgs.getOwner(), Long.parseLong(volumeArgs.getQuota()), System.currentTimeMillis(), volumeArgs.getAcls());
        this.volumes.put(volumeName, volume);
    }

    public OzoneVolume getVolume(String volumeName) throws IOException {
        if (this.volumes.containsKey(volumeName)) {
            return this.volumes.get(volumeName);
        }
        throw new OMException("", OMException.ResultCodes.VOLUME_NOT_FOUND);
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix) throws IOException {
        return this.volumes.values().stream().filter(volume -> volume.getName().startsWith(volumePrefix)).collect(Collectors.toList()).iterator();
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix, String prevVolume) throws IOException {
        return this.volumes.values().stream().filter(volume -> volume.getName().compareTo(prevVolume) > 0).filter(volume -> volume.getName().startsWith(volumePrefix)).collect(Collectors.toList()).iterator();
    }

    public Iterator<? extends OzoneVolume> listVolumesByUser(String user, String volumePrefix, String prevVolume) throws IOException {
        return this.volumes.values().stream().filter(volume -> volume.getOwner().equals(user)).filter(volume -> volume.getName().compareTo(prevVolume) < 0).filter(volume -> volume.getName().startsWith(volumePrefix)).collect(Collectors.toList()).iterator();
    }

    public void deleteVolume(String volumeName) throws IOException {
        this.volumes.remove(volumeName);
    }

    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        String volumeName = "s3" + userName;
        if (this.bucketVolumeMap.get(s3BucketName) != null) {
            throw new OMException("", OMException.ResultCodes.BUCKET_ALREADY_EXISTS);
        }
        this.bucketVolumeMap.put(s3BucketName, volumeName + "/" + s3BucketName);
        this.bucketEmptyStatus.put(s3BucketName, true);
        this.createVolume(volumeName);
        this.volumes.get(volumeName).createBucket(s3BucketName);
        if (this.userBuckets.get(userName) == null) {
            ArrayList<OzoneBucket> ozoneBuckets = new ArrayList<OzoneBucket>();
            ozoneBuckets.add(this.volumes.get(volumeName).getBucket(s3BucketName));
            this.userBuckets.put(userName, ozoneBuckets);
        } else {
            this.userBuckets.get(userName).add(this.volumes.get(volumeName).getBucket(s3BucketName));
        }
    }

    public Iterator<? extends OzoneBucket> listS3Buckets(String userName, String bucketPrefix) {
        if (this.userBuckets.get(userName) == null) {
            return new ArrayList().iterator();
        }
        return this.userBuckets.get(userName).parallelStream().filter(ozoneBucket -> {
            if (bucketPrefix != null) {
                return ozoneBucket.getName().startsWith(bucketPrefix);
            }
            return true;
        }).collect(Collectors.toList()).iterator();
    }

    public Iterator<? extends OzoneBucket> listS3Buckets(String userName, String bucketPrefix, String prevBucket) {
        if (this.userBuckets.get(userName) == null) {
            return new ArrayList().iterator();
        }
        this.userBuckets.get(userName).sort((bucket1, bucket2) -> {
            int compare = bucket1.getName().compareTo(bucket2.getName());
            if (compare < 0) {
                return -1;
            }
            if (compare == 0) {
                return 0;
            }
            return 1;
        });
        return this.userBuckets.get(userName).stream().filter(ozoneBucket -> {
            if (prevBucket != null) {
                return ozoneBucket.getName().compareTo(prevBucket) > 0;
            }
            return true;
        }).filter(ozoneBucket -> {
            if (bucketPrefix != null) {
                return ozoneBucket.getName().startsWith(bucketPrefix);
            }
            return true;
        }).collect(Collectors.toList()).iterator();
    }

    public void deleteS3Bucket(String s3BucketName) throws IOException {
        if (this.bucketVolumeMap.containsKey(s3BucketName)) {
            if (!this.bucketEmptyStatus.get(s3BucketName).booleanValue()) {
                throw new OMException("", OMException.ResultCodes.BUCKET_NOT_EMPTY);
            }
        } else {
            throw new OMException("", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        this.bucketVolumeMap.remove(s3BucketName);
    }

    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        if (this.bucketVolumeMap.get(s3BucketName) == null) {
            throw new OMException("", OMException.ResultCodes.S3_BUCKET_NOT_FOUND);
        }
        return this.bucketVolumeMap.get(s3BucketName);
    }

    public String getOzoneVolumeName(String s3BucketName) throws IOException {
        if (this.bucketVolumeMap.get(s3BucketName) == null) {
            throw new OMException("", OMException.ResultCodes.S3_BUCKET_NOT_FOUND);
        }
        return this.bucketVolumeMap.get(s3BucketName).split("/")[0];
    }

    public String getOzoneBucketName(String s3BucketName) throws IOException {
        if (this.bucketVolumeMap.get(s3BucketName) == null) {
            throw new OMException("", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        return this.bucketVolumeMap.get(s3BucketName).split("/")[1];
    }

    public void setBucketEmptyStatus(String bucketName, boolean status) {
        this.bucketEmptyStatus.put(bucketName, status);
    }
}

