/*
 * Decompiled with CFR 0.152.
 */
package org.hadoop.ozone.recon.schema;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hadoop.ozone.recon.schema.ReconSchemaDefinition;
import org.jooq.Constraint;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.transaction.annotation.Transactional;

public class UtilizationSchemaDefinition
implements ReconSchemaDefinition {
    private final DataSource dataSource;
    public static final String CLUSTER_GROWTH_DAILY_TABLE_NAME = "cluster_growth_daily";
    public static final String FILE_COUNT_BY_SIZE_TABLE_NAME = "file_count_by_size";
    public static final String MISSING_CONTAINERS_TABLE_NAME = "missing_containers";

    @Inject
    UtilizationSchemaDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    @Transactional
    public void initializeSchema() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        this.createClusterGrowthTable(conn);
        this.createFileSizeCount(conn);
        this.createMissingContainersTable(conn);
    }

    void createClusterGrowthTable(Connection conn) {
        DSL.using((Connection)conn).createTableIfNotExists(CLUSTER_GROWTH_DAILY_TABLE_NAME).column("timestamp", SQLDataType.TIMESTAMP).column("datanode_id", SQLDataType.INTEGER).column("datanode_host", SQLDataType.VARCHAR((int)1024)).column("rack_id", SQLDataType.VARCHAR((int)1024)).column("available_size", SQLDataType.BIGINT).column("used_size", SQLDataType.BIGINT).column("container_count", SQLDataType.INTEGER).column("block_count", SQLDataType.INTEGER).constraint((Constraint)DSL.constraint((String)"pk_timestamp_datanode_id").primaryKey(new String[]{"timestamp", "datanode_id"})).execute();
    }

    void createFileSizeCount(Connection conn) {
        DSL.using((Connection)conn).createTableIfNotExists(FILE_COUNT_BY_SIZE_TABLE_NAME).column("file_size", SQLDataType.BIGINT).column("count", SQLDataType.BIGINT).constraint((Constraint)DSL.constraint((String)"pk_file_size").primaryKey(new String[]{"file_size"})).execute();
    }

    void createMissingContainersTable(Connection conn) {
        DSL.using((Connection)conn).createTableIfNotExists(MISSING_CONTAINERS_TABLE_NAME).column("container_id", SQLDataType.BIGINT).column("missing_since", SQLDataType.BIGINT).constraint((Constraint)DSL.constraint((String)"pk_container_id").primaryKey(new String[]{"container_id"})).execute();
    }
}

