/*
 * Decompiled with CFR 0.152.
 */
package org.hadoop.ozone.recon.schema;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hadoop.ozone.recon.schema.ReconSchemaDefinition;
import org.jooq.Constraint;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class StatsSchemaDefinition
implements ReconSchemaDefinition {
    public static final String GLOBAL_STATS_TABLE_NAME = "global_stats";
    private final DataSource dataSource;

    @Inject
    StatsSchemaDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void initializeSchema() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        this.createGlobalStatsTable(conn);
    }

    private void createGlobalStatsTable(Connection conn) {
        DSL.using((Connection)conn).createTableIfNotExists(GLOBAL_STATS_TABLE_NAME).column("key", SQLDataType.VARCHAR((int)255)).column("value", SQLDataType.BIGINT).column("last_updated_timestamp", SQLDataType.TIMESTAMP).constraint((Constraint)DSL.constraint((String)"pk_key").primaryKey(new String[]{"key"})).execute();
    }
}

