/*
 * Decompiled with CFR 0.152.
 */
package org.hadoop.ozone.recon.codegen;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.hadoop.ozone.recon.codegen.ReconSchemaGenerationModule;
import org.hadoop.ozone.recon.schema.ReconSchemaDefinition;
import org.jooq.codegen.GenerationTool;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Generate;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Strategy;
import org.jooq.meta.jaxb.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteDataSource;

public class JooqCodeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JooqCodeGenerator.class);
    private static final String SQLITE_DB = System.getProperty("java.io.tmpdir") + "/recon-generated-schema";
    private static final String JDBC_URL = "jdbc:sqlite:" + SQLITE_DB;
    private final Set<ReconSchemaDefinition> allDefinitions;

    @Inject
    public JooqCodeGenerator(Set<ReconSchemaDefinition> allDefinitions) {
        this.allDefinitions = allDefinitions;
    }

    private void initializeSchema() throws SQLException {
        for (ReconSchemaDefinition definition : this.allDefinitions) {
            definition.initializeSchema();
        }
    }

    private void generateSourceCode(String outputDir) throws Exception {
        Configuration configuration = new Configuration().withJdbc(new Jdbc().withDriver("org.sqlite.JDBC").withUrl(JDBC_URL).withUser("sa").withPassword("sa")).withGenerator(new Generator().withDatabase(new Database().withName("org.jooq.meta.sqlite.SQLiteDatabase").withOutputSchemaToDefault(Boolean.valueOf(true)).withIncludeTables(Boolean.valueOf(true)).withIncludePrimaryKeys(Boolean.valueOf(true))).withGenerate(new Generate().withDaos(Boolean.valueOf(true)).withEmptyCatalogs(Boolean.valueOf(true)).withEmptySchemas(Boolean.valueOf(true))).withStrategy(new Strategy().withName("org.hadoop.ozone.recon.codegen.TableNamingStrategy")).withTarget(new Target().withPackageName("org.hadoop.ozone.recon.schema").withClean(Boolean.valueOf(true)).withDirectory(outputDir)));
        GenerationTool.generate((Configuration)configuration);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing required arguments: Need a ouput directory for generated code.\nUsage: org.apache.hadoop.ozone.recon.persistence.JooqCodeGenerator <outputDirectory>.");
        }
        String outputDir = args[0];
        Injector injector = Guice.createInjector((Module[])new Module[]{new ReconSchemaGenerationModule(), new AbstractModule(){

            protected void configure() {
                this.bind(DataSource.class).toProvider((Provider)new LocalDataSourceProvider());
                this.bind(JooqCodeGenerator.class);
            }
        }});
        JooqCodeGenerator codeGenerator = (JooqCodeGenerator)injector.getInstance(JooqCodeGenerator.class);
        try {
            codeGenerator.initializeSchema();
        }
        catch (SQLException e) {
            LOG.error("Unable to initialize schema.", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        try {
            codeGenerator.generateSourceCode(outputDir);
        }
        catch (Exception e) {
            LOG.error("Code generation failed. Aborting build.", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        LocalDataSourceProvider.cleanup();
    }

    static class LocalDataSourceProvider
    implements Provider<DataSource> {
        private static SQLiteDataSource db = new SQLiteDataSource();

        LocalDataSourceProvider() {
        }

        public DataSource get() {
            return db;
        }

        static void cleanup() {
            FileUtils.deleteQuietly((File)new File(SQLITE_DB));
        }

        static {
            db.setUrl(JDBC_URL);
        }
    }
}

