/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ozone.OzoneFileSystem;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={OzoneClientFactory.class, UserGroupInformation.class})
@PowerMockIgnore(value={"javax.management.*"})
public class TestOzoneFileSystemWithMocks {
    @Test
    public void testFSUriWithHostPortOverrides() throws Exception {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.mockClientFactory((Configuration)conf, 5899);
        this.mockUser();
        URI uri = new URI("o3fs://bucket1.volume1.local.host:5899");
        FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)conf);
        OzoneFileSystem ozfs = (OzoneFileSystem)fileSystem;
        Assert.assertEquals((Object)"bucket1.volume1.local.host:5899", (Object)ozfs.getUri().getAuthority());
        PowerMockito.verifyStatic();
        OzoneClientFactory.getRpcClient((String)"local.host", (Integer)5899, (Configuration)conf);
    }

    @Test
    public void testFSUriWithHostPortUnspecified() throws Exception {
        OzoneConfiguration conf = new OzoneConfiguration();
        int omPort = OmUtils.getOmRpcPort((Configuration)conf);
        this.mockClientFactory((Configuration)conf, omPort);
        this.mockUser();
        URI uri = new URI("o3fs://bucket1.volume1.local.host");
        FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)conf);
        OzoneFileSystem ozfs = (OzoneFileSystem)fileSystem;
        Assert.assertEquals((Object)"bucket1.volume1.local.host", (Object)ozfs.getUri().getHost());
        Assert.assertEquals((long)ozfs.getUri().getPort(), (long)-1L);
        PowerMockito.verifyStatic();
        OzoneClientFactory.getRpcClient((String)"local.host", (Integer)omPort, (Configuration)conf);
    }

    @Test
    public void testFSUriHostVersionDefault() throws Exception {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.mockClientFactory((Configuration)conf);
        this.mockUser();
        URI uri = new URI("o3fs://bucket1.volume1/key");
        FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)conf);
        OzoneFileSystem ozfs = (OzoneFileSystem)fileSystem;
        Assert.assertEquals((Object)"bucket1.volume1", (Object)ozfs.getUri().getAuthority());
        PowerMockito.verifyStatic();
        OzoneClientFactory.getRpcClient((Configuration)conf);
    }

    @Test
    public void testReplicationDefaultValue() throws IOException, URISyntaxException {
        OzoneConfiguration conf = new OzoneConfiguration();
        int defaultValue = conf.getInt("ozone.replication", 3);
        this.mockClientFactory((Configuration)conf);
        this.mockUser();
        URI uri = new URI("o3fs://bucket1.volume1/key");
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)defaultValue, (long)fs.getDefaultReplication(new Path("/any")));
    }

    @Test
    public void testReplicationCustomValue() throws IOException, URISyntaxException {
        OzoneConfiguration conf = new OzoneConfiguration();
        int configured = 1;
        conf.setInt("ozone.replication", configured);
        this.mockClientFactory((Configuration)conf);
        this.mockUser();
        URI uri = new URI("o3fs://bucket1.volume1/key");
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)configured, (long)fs.getDefaultReplication(new Path("/any")));
    }

    private OzoneClient mockClient() throws IOException {
        OzoneClient ozoneClient = (OzoneClient)Mockito.mock(OzoneClient.class);
        ObjectStore objectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
        OzoneVolume volume = (OzoneVolume)Mockito.mock(OzoneVolume.class);
        OzoneBucket bucket = (OzoneBucket)Mockito.mock(OzoneBucket.class);
        Mockito.when((Object)ozoneClient.getObjectStore()).thenReturn((Object)objectStore);
        Mockito.when((Object)objectStore.getVolume((String)Matchers.eq((Object)"volume1"))).thenReturn((Object)volume);
        Mockito.when((Object)volume.getBucket("bucket1")).thenReturn((Object)bucket);
        return ozoneClient;
    }

    private void mockClientFactory(Configuration conf, int omPort) throws IOException {
        OzoneClient ozoneClient = this.mockClient();
        PowerMockito.mockStatic(OzoneClientFactory.class, (Class[])new Class[0]);
        PowerMockito.when((Object)OzoneClientFactory.getRpcClient((String)((String)Matchers.eq((Object)"local.host")), (Integer)Matchers.eq((int)omPort), (Configuration)((Configuration)Matchers.eq((Object)conf)))).thenReturn((Object)ozoneClient);
    }

    private void mockClientFactory(Configuration conf) throws IOException {
        OzoneClient ozoneClient = this.mockClient();
        PowerMockito.mockStatic(OzoneClientFactory.class, (Class[])new Class[0]);
        PowerMockito.when((Object)OzoneClientFactory.getRpcClient((Configuration)((Configuration)Matchers.eq((Object)conf)))).thenReturn((Object)ozoneClient);
    }

    private void mockUser() throws IOException {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        PowerMockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn((Object)ugi);
        Mockito.when((Object)ugi.getShortUserName()).thenReturn((Object)"user1");
    }
}

