/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ozone.CapableOzoneFSInputStream;
import org.apache.hadoop.fs.ozone.OzoneFSInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestOzoneFSInputStream {
    private static final List<IntFunction<ByteBuffer>> BUFFER_CONSTRUCTORS = ImmutableList.of(ByteBuffer::allocate, ByteBuffer::allocateDirect);

    @Test
    public void readToByteBuffer() throws IOException {
        for (IntFunction<ByteBuffer> constructor : BUFFER_CONSTRUCTORS) {
            for (int streamLength = 1; streamLength <= 10; ++streamLength) {
                for (int bufferCapacity = 0; bufferCapacity <= 10; ++bufferCapacity) {
                    TestOzoneFSInputStream.testReadToByteBuffer(constructor, streamLength, bufferCapacity, 0);
                    if (bufferCapacity > 1) {
                        TestOzoneFSInputStream.testReadToByteBuffer(constructor, streamLength, bufferCapacity, 1);
                        if (bufferCapacity > 2) {
                            TestOzoneFSInputStream.testReadToByteBuffer(constructor, streamLength, bufferCapacity, bufferCapacity - 1);
                        }
                    }
                    TestOzoneFSInputStream.testReadToByteBuffer(constructor, streamLength, bufferCapacity, bufferCapacity);
                }
            }
        }
    }

    private static void testReadToByteBuffer(IntFunction<ByteBuffer> bufferConstructor, int streamLength, int bufferCapacity, int bufferPosition) throws IOException {
        byte[] source = RandomUtils.nextBytes((int)streamLength);
        ByteArrayInputStream input = new ByteArrayInputStream(source);
        OzoneFSInputStream subject = TestOzoneFSInputStream.createTestSubject(input);
        int expectedReadLength = Math.min(bufferCapacity - bufferPosition, ((InputStream)input).available());
        byte[] expectedContent = Arrays.copyOfRange(source, 0, expectedReadLength);
        ByteBuffer buf = bufferConstructor.apply(bufferCapacity);
        buf.position(bufferPosition);
        int bytesRead = subject.read(buf);
        Assert.assertEquals((long)expectedReadLength, (long)bytesRead);
        byte[] content = new byte[bytesRead];
        buf.position(bufferPosition);
        buf.get(content);
        Assert.assertArrayEquals((byte[])expectedContent, (byte[])content);
    }

    @Test
    public void readEmptyStreamToByteBuffer() throws IOException {
        for (IntFunction<ByteBuffer> constructor : BUFFER_CONSTRUCTORS) {
            OzoneFSInputStream subject = TestOzoneFSInputStream.createTestSubject(TestOzoneFSInputStream.emptyStream());
            ByteBuffer buf = constructor.apply(1);
            int bytesRead = subject.read(buf);
            Assert.assertEquals((long)-1L, (long)bytesRead);
            Assert.assertEquals((long)0L, (long)buf.position());
        }
    }

    @Test
    public void bufferPositionUnchangedOnEOF() throws IOException {
        for (IntFunction<ByteBuffer> constructor : BUFFER_CONSTRUCTORS) {
            OzoneFSInputStream subject = TestOzoneFSInputStream.createTestSubject(TestOzoneFSInputStream.eofStream());
            ByteBuffer buf = constructor.apply(123);
            int bytesRead = subject.read(buf);
            Assert.assertEquals((long)-1L, (long)bytesRead);
            Assert.assertEquals((long)0L, (long)buf.position());
        }
    }

    @Test
    public void testStreamCapability() {
        OzoneFSInputStream subject = TestOzoneFSInputStream.createTestSubject(TestOzoneFSInputStream.emptyStream());
        CapableOzoneFSInputStream capableOzoneFSInputStream = new CapableOzoneFSInputStream((InputStream)subject, new FileSystem.Statistics("test"));
        Assert.assertTrue((boolean)capableOzoneFSInputStream.hasCapability("in:readbytebuffer"));
    }

    private static OzoneFSInputStream createTestSubject(InputStream input) {
        return new OzoneFSInputStream(input, new FileSystem.Statistics("test"));
    }

    private static InputStream emptyStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    private static InputStream eofStream() {
        return new InputStream(){

            @Override
            public int available() {
                return 123;
            }

            @Override
            public int read() {
                return -1;
            }
        };
    }
}

