/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.http;

import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RestClientBindings {
    private static final Log LOG = LogFactory.getLog(RestClientBindings.class);
    public static final String E_INVALID_NAME = "Invalid swift hostname '%s': hostname must in form container.service";

    public static String buildSwiftInstancePrefix(String service) {
        return "fs.swift.service." + service;
    }

    private static SwiftConfigurationException invalidName(String hostname) {
        return new SwiftConfigurationException(String.format("Invalid swift hostname '%s': hostname must in form container.service", hostname));
    }

    public static String extractContainerName(String hostname) throws SwiftConfigurationException {
        int i = hostname.indexOf(".");
        if (i <= 0) {
            throw RestClientBindings.invalidName((String)hostname);
        }
        return hostname.substring(0, i);
    }

    public static String extractContainerName(URI uri) throws SwiftConfigurationException {
        return RestClientBindings.extractContainerName((String)uri.getHost());
    }

    public static String extractServiceName(String hostname) throws SwiftConfigurationException {
        int i = hostname.indexOf(".");
        if (i <= 0) {
            throw RestClientBindings.invalidName((String)hostname);
        }
        String service = hostname.substring(i + 1);
        if (service.isEmpty() || service.contains(".")) {
            throw RestClientBindings.invalidName((String)hostname);
        }
        return service;
    }

    public static String extractServiceName(URI uri) throws SwiftConfigurationException {
        return RestClientBindings.extractServiceName((String)uri.getHost());
    }

    public static Properties bind(URI fsURI, Configuration conf) throws SwiftConfigurationException {
        String host = fsURI.getHost();
        if (host == null || host.isEmpty()) {
            throw RestClientBindings.invalidName((String)host);
        }
        String container = RestClientBindings.extractContainerName((String)host);
        String service = RestClientBindings.extractServiceName((String)host);
        String prefix = RestClientBindings.buildSwiftInstancePrefix((String)service);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Filesystem " + fsURI + " is using configuration keys " + prefix));
        }
        Properties props = new Properties();
        props.setProperty("fs.swift.SERVICE-NAME", service);
        props.setProperty("fs.swift.CONTAINER-NAME", container);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".auth.url"), (Properties)props, (String)"fs.swift.auth.url", (boolean)true);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".username"), (Properties)props, (String)"fs.swift.username", (boolean)true);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".apikey"), (Properties)props, (String)"fs.swift.apikey", (boolean)false);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".password"), (Properties)props, (String)"fs.swift.password", (props.contains("fs.swift.apikey") ? 1 : 0) != 0);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".tenant"), (Properties)props, (String)"fs.swift.tenant", (boolean)false);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".region"), (Properties)props, (String)"fs.swift.region", (boolean)false);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".http.port"), (Properties)props, (String)"fs.swift.http.port", (boolean)false);
        RestClientBindings.copy((Configuration)conf, (String)(prefix + ".https.port"), (Properties)props, (String)"fs.swift.https.port", (boolean)false);
        RestClientBindings.copyBool((Configuration)conf, (String)(prefix + ".public"), (Properties)props, (String)"fs.swift.public", (boolean)false);
        RestClientBindings.copyBool((Configuration)conf, (String)(prefix + ".location-aware"), (Properties)props, (String)"fs.swift.location-aware", (boolean)false);
        return props;
    }

    private static void copyBool(Configuration conf, String confKey, Properties props, String propsKey, boolean defVal) {
        boolean b = conf.getBoolean(confKey, defVal);
        props.setProperty(propsKey, Boolean.toString(b));
    }

    private static void set(Properties props, String key, String optVal) {
        if (optVal != null) {
            props.setProperty(key, optVal);
        }
    }

    public static void copy(Configuration conf, String confKey, Properties props, String propsKey, boolean required) throws SwiftConfigurationException {
        String val = conf.get(confKey);
        if (val != null) {
            val = val.trim();
        }
        if (required && val == null) {
            throw new SwiftConfigurationException("Missing mandatory configuration option: " + confKey);
        }
        RestClientBindings.set((Properties)props, (String)propsKey, (String)val);
    }
}

