/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class LOOKUP3Response
extends NFS3Response {
    private final FileHandle fileHandle;
    private final Nfs3FileAttributes postOpObjAttr;
    private final Nfs3FileAttributes postOpDirAttr;

    public LOOKUP3Response(int status) {
        this(status, null, new Nfs3FileAttributes(), new Nfs3FileAttributes());
    }

    public LOOKUP3Response(int status, FileHandle fileHandle, Nfs3FileAttributes postOpObjAttr, Nfs3FileAttributes postOpDirAttributes) {
        super(status);
        this.fileHandle = fileHandle;
        this.postOpObjAttr = postOpObjAttr;
        this.postOpDirAttr = postOpDirAttributes;
    }

    public LOOKUP3Response(XDR xdr) throws IOException {
        super(-1);
        this.fileHandle = new FileHandle();
        this.status = xdr.readInt();
        Nfs3FileAttributes objAttr = null;
        if (this.status == 0) {
            if (!this.fileHandle.deserialize(xdr)) {
                throw new IOException("can't deserialize file handle");
            }
            objAttr = xdr.readBoolean() ? Nfs3FileAttributes.deserialize((XDR)xdr) : null;
        }
        this.postOpObjAttr = objAttr;
        this.postOpDirAttr = xdr.readBoolean() ? Nfs3FileAttributes.deserialize((XDR)xdr) : null;
    }

    public XDR serialize(XDR out, int xid, Verifier verifier) {
        super.serialize(out, xid, verifier);
        if (this.status == 0) {
            this.fileHandle.serialize(out);
            out.writeBoolean(true);
            this.postOpObjAttr.serialize(out);
        }
        out.writeBoolean(true);
        this.postOpDirAttr.serialize(out);
        return out;
    }
}

