/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.oncrpc.XDR;

/*
 * Exception performing whole class analysis ignored.
 */
public class MKNOD3Request
extends RequestWithHandle {
    private final String name;
    private int type;
    private SetAttr3 objAttr = null;
    private Nfs3FileAttributes.Specdata3 spec = null;

    public MKNOD3Request(FileHandle handle, String name, int type, SetAttr3 objAttr, Nfs3FileAttributes.Specdata3 spec) {
        super(handle);
        this.name = name;
        this.type = type;
        this.objAttr = objAttr;
        this.spec = spec;
    }

    public static MKNOD3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = MKNOD3Request.readHandle((XDR)xdr);
        String name = xdr.readString();
        int type = xdr.readInt();
        SetAttr3 objAttr = new SetAttr3();
        Nfs3FileAttributes.Specdata3 spec = null;
        if (type == NfsFileType.NFSCHR.toValue() || type == NfsFileType.NFSBLK.toValue()) {
            objAttr.deserialize(xdr);
            spec = new Nfs3FileAttributes.Specdata3(xdr.readInt(), xdr.readInt());
        } else if (type == NfsFileType.NFSSOCK.toValue() || type == NfsFileType.NFSFIFO.toValue()) {
            objAttr.deserialize(xdr);
        }
        return new MKNOD3Request(handle, name, type, objAttr, spec);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public SetAttr3 getObjAttr() {
        return this.objAttr;
    }

    public Nfs3FileAttributes.Specdata3 getSpec() {
        return this.spec;
    }

    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeInt(this.name.length());
        xdr.writeFixedOpaque(this.name.getBytes(), this.name.length());
        this.objAttr.serialize(xdr);
        if (this.spec != null) {
            xdr.writeInt(this.spec.getSpecdata1());
            xdr.writeInt(this.spec.getSpecdata2());
        }
    }
}

