/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.nfs.AccessPrivilege;
import org.apache.hadoop.nfs.NfsExports;
import org.apache.hadoop.util.LightWeightCache;

/*
 * Exception performing whole class analysis ignored.
 */
public class NfsExports {
    private static NfsExports exports = null;
    public static final Log LOG = LogFactory.getLog(NfsExports.class);
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT_SHORT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    private static final String SLASH_FORMAT_LONG = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final Pattern CIDR_FORMAT_SHORT = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    private static final Pattern CIDR_FORMAT_LONG = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final String LABEL_FORMAT = "[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?";
    private static final Pattern HOSTNAME_FORMAT = Pattern.compile("^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)*[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?$");
    private final List<Match> mMatches;
    private final LightWeightCache<AccessCacheEntry, AccessCacheEntry> accessCache;
    private final long cacheExpirationPeriod;

    public static synchronized NfsExports getInstance(Configuration conf) {
        if (exports == null) {
            String matchHosts = conf.get("nfs.exports.allowed.hosts", "* rw");
            int cacheSize = conf.getInt("nfs.exports.cache.size", 512);
            long expirationPeriodNano = conf.getLong("nfs.exports.cache.expirytime.millis", 900000L) * 1000L * 1000L;
            try {
                exports = new NfsExports(cacheSize, expirationPeriodNano, matchHosts);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Invalid NFS Exports provided: ", (Throwable)e);
                return exports;
            }
        }
        return exports;
    }

    NfsExports(int cacheSize, long expirationPeriodNano, String matchHosts) {
        this.cacheExpirationPeriod = expirationPeriodNano;
        this.accessCache = new LightWeightCache(cacheSize, cacheSize, expirationPeriodNano, 0L);
        String[] matchStrings = matchHosts.split(";");
        this.mMatches = new ArrayList(matchStrings.length);
        for (String mStr : matchStrings) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing match string '" + mStr + "'"));
            }
            if ((mStr = mStr.trim()).isEmpty()) continue;
            this.mMatches.add(NfsExports.getMatch((String)mStr));
        }
    }

    public String[] getHostGroupList() {
        int listSize = this.mMatches.size();
        String[] hostGroups = new String[listSize];
        for (int i = 0; i < this.mMatches.size(); ++i) {
            hostGroups[i] = ((Match)this.mMatches.get(i)).getHostGroup();
        }
        return hostGroups;
    }

    public AccessPrivilege getAccessPrivilege(InetAddress addr) {
        return this.getAccessPrivilege(addr.getHostAddress(), addr.getCanonicalHostName());
    }

    AccessPrivilege getAccessPrivilege(String address, String hostname) {
        long now = System.nanoTime();
        AccessCacheEntry newEntry = new AccessCacheEntry(address, AccessPrivilege.NONE, now + this.cacheExpirationPeriod);
        AccessCacheEntry cachedEntry = (AccessCacheEntry)this.accessCache.get((Object)newEntry);
        if (cachedEntry != null && now < AccessCacheEntry.access$000((AccessCacheEntry)cachedEntry)) {
            return AccessCacheEntry.access$100((AccessCacheEntry)cachedEntry);
        }
        for (Match match : this.mMatches) {
            if (!match.isIncluded(address, hostname)) continue;
            if (Match.access$200((Match)match) == AccessPrivilege.READ_ONLY) {
                AccessCacheEntry.access$102((AccessCacheEntry)newEntry, (AccessPrivilege)AccessPrivilege.READ_ONLY);
                break;
            }
            if (Match.access$200((Match)match) != AccessPrivilege.READ_WRITE) continue;
            AccessCacheEntry.access$102((AccessCacheEntry)newEntry, (AccessPrivilege)AccessPrivilege.READ_WRITE);
        }
        this.accessCache.put((Object)newEntry);
        return AccessCacheEntry.access$100((AccessCacheEntry)newEntry);
    }

    private static Match getMatch(String line) {
        String host;
        String[] parts = line.split("\\s+");
        AccessPrivilege privilege = AccessPrivilege.READ_ONLY;
        switch (parts.length) {
            case 1: {
                host = parts[0].toLowerCase().trim();
                break;
            }
            case 2: {
                host = parts[0].toLowerCase().trim();
                String option = parts[1].trim();
                if (!"rw".equalsIgnoreCase(option)) break;
                privilege = AccessPrivilege.READ_WRITE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrectly formatted line '" + line + "'");
            }
        }
        if (host.equals("*")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using match all for '" + host + "' and " + privilege));
            }
            return new AnonymousMatch(privilege, null);
        }
        if (CIDR_FORMAT_SHORT.matcher(host).matches()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using CIDR match for '" + host + "' and " + privilege));
            }
            return new CIDRMatch(privilege, new SubnetUtils(host).getInfo(), null);
        }
        if (CIDR_FORMAT_LONG.matcher(host).matches()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using CIDR match for '" + host + "' and " + privilege));
            }
            String[] pair = host.split("/");
            return new CIDRMatch(privilege, new SubnetUtils(pair[0], pair[1]).getInfo(), null);
        }
        if (host.contains("*") || host.contains("?") || host.contains("[") || host.contains("]")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using Regex match for '" + host + "' and " + privilege));
            }
            return new RegexMatch(privilege, host, null);
        }
        if (HOSTNAME_FORMAT.matcher(host).matches()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using exact match for '" + host + "' and " + privilege));
            }
            return new ExactMatch(privilege, host, null);
        }
        throw new IllegalArgumentException("Invalid hostname provided '" + host + "'");
    }
}

