/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.SimpleUdpServer;
import org.apache.hadoop.portmap.RpcProgramPortmap;
import org.apache.hadoop.util.StringUtils;

public class Portmap {
    public static final Log LOG = LogFactory.getLog(Portmap.class);

    private static void startUDPServer(RpcProgramPortmap rpcProgram) {
        rpcProgram.register(17);
        SimpleUdpServer udpServer = new SimpleUdpServer(111, rpcProgram, 1);
        udpServer.run();
    }

    private static void startTCPServer(RpcProgramPortmap rpcProgram) {
        rpcProgram.register(6);
        SimpleTcpServer tcpServer = new SimpleTcpServer(111, rpcProgram, 1);
        tcpServer.run();
    }

    public static void main(String[] args) {
        StringUtils.startupShutdownMessage(Portmap.class, (String[])args, (Log)LOG);
        RpcProgramPortmap program = new RpcProgramPortmap();
        try {
            Portmap.startUDPServer(program);
            Portmap.startTCPServer(program);
        }
        catch (Throwable e) {
            LOG.fatal((Object)"Start server failure");
            System.exit(-1);
        }
    }
}

