/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.CredentialsGSS;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.CredentialsSys;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;

public abstract class Credentials
extends RpcAuthInfo {
    public static final Log LOG = LogFactory.getLog(Credentials.class);
    protected int mCredentialsLength;

    public static Credentials readFlavorAndCredentials(XDR xdr) {
        Credentials credentials;
        RpcAuthInfo.AuthFlavor flavor = RpcAuthInfo.AuthFlavor.fromValue(xdr.readInt());
        if (flavor == RpcAuthInfo.AuthFlavor.AUTH_NONE) {
            credentials = new CredentialsNone();
        } else if (flavor == RpcAuthInfo.AuthFlavor.AUTH_SYS) {
            credentials = new CredentialsSys();
        } else if (flavor == RpcAuthInfo.AuthFlavor.RPCSEC_GSS) {
            credentials = new CredentialsGSS();
        } else {
            throw new UnsupportedOperationException("Unsupported Credentials Flavor " + (Object)((Object)flavor));
        }
        ((RpcAuthInfo)credentials).read(xdr);
        return credentials;
    }

    protected Credentials(RpcAuthInfo.AuthFlavor flavor) {
        super(flavor);
    }
}

