/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.XDR;

public abstract class RpcReply
extends RpcMessage {
    private final ReplyState state;

    RpcReply(int xid, RpcMessage.Type messageType, ReplyState state) {
        super(xid, messageType);
        this.state = state;
        this.validateMessageType(RpcMessage.Type.RPC_REPLY);
    }

    public static RpcReply read(XDR xdr) {
        int xid = xdr.readInt();
        RpcMessage.Type messageType = RpcMessage.Type.fromValue(xdr.readInt());
        ReplyState stat = ReplyState.fromValue(xdr.readInt());
        switch (stat) {
            case MSG_ACCEPTED: {
                return RpcAcceptedReply.read(xid, messageType, stat, xdr);
            }
            case MSG_DENIED: {
                return RpcDeniedReply.read(xid, messageType, stat, xdr);
            }
        }
        return null;
    }

    public ReplyState getState() {
        return this.state;
    }

    public static enum ReplyState {
        MSG_ACCEPTED,
        MSG_DENIED;


        int getValue() {
            return this.ordinal();
        }

        public static ReplyState fromValue(int value) {
            return ReplyState.values()[value];
        }
    }
}

