/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class RpcFrameDecoder
extends FrameDecoder {
    public static final Log LOG = LogFactory.getLog(RpcFrameDecoder.class);
    private ChannelBuffer frame;

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buf) {
        ChannelBuffer tmp;
        if (buf.readableBytes() < 4) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Length field is not received yet");
            }
            return null;
        }
        buf.markReaderIndex();
        ChannelBuffer fragmentHeader = buf.readBytes(4);
        int length = XDR.fragmentSize(fragmentHeader.array());
        boolean isLast = XDR.isLastFragment(fragmentHeader.array());
        if (buf.readableBytes() < length) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(length + " bytes are not received yet"));
            }
            buf.resetReaderIndex();
            return null;
        }
        this.frame = this.frame == null ? buf.readBytes(length) : (tmp = ChannelBuffers.copiedBuffer((byte[][])new byte[][]{this.frame.array(), buf.readBytes(length).array()}));
        if (isLast) {
            ChannelBuffer completeFrame = this.frame;
            this.frame = null;
            return completeFrame;
        }
        LOG.info((Object)"Wait for the next frame. This rarely happens.");
        return null;
    }
}

