/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mount;

import java.util.List;
import org.apache.hadoop.mount.MountEntry;
import org.apache.hadoop.nfs.NfsExports;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;

public class MountResponse {
    public static final int MNT_OK = 0;

    private MountResponse() {
    }

    public static XDR writeMNTResponse(int status, XDR xdr, int xid, byte[] handle) {
        RpcAcceptedReply.voidReply(xdr, xid);
        xdr.writeInt(status);
        if (status == 0) {
            xdr.writeVariableOpaque(handle);
            xdr.writeInt(1);
            xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_SYS.getValue());
        }
        return xdr;
    }

    public static XDR writeMountList(XDR xdr, int xid, List<MountEntry> mounts) {
        RpcAcceptedReply.voidReply(xdr, xid);
        for (MountEntry mountEntry : mounts) {
            xdr.writeBoolean(true);
            xdr.writeString(mountEntry.host());
            xdr.writeString(mountEntry.path());
        }
        xdr.writeBoolean(false);
        return xdr;
    }

    public static XDR writeExportList(XDR xdr, int xid, List<String> exports, List<NfsExports> hostMatcher) {
        assert (exports.size() == hostMatcher.size());
        RpcAcceptedReply.voidReply(xdr, xid);
        for (int i = 0; i < exports.size(); ++i) {
            xdr.writeBoolean(true);
            xdr.writeString(exports.get(i));
            String[] hostGroups = hostMatcher.get(i).getHostGroupList();
            if (hostGroups.length > 0) {
                for (int j = 0; j < hostGroups.length; ++j) {
                    xdr.writeBoolean(true);
                    xdr.writeVariableOpaque(hostGroups[j].getBytes());
                }
            }
            xdr.writeBoolean(false);
        }
        xdr.writeBoolean(false);
        return xdr;
    }
}

