/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.protoc;

import java.io.File;
import java.util.ArrayList;
import org.apache.hadoop.maven.plugin.util.Exec;
import org.apache.hadoop.maven.plugin.util.FileSetUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@org.apache.maven.plugins.annotations.Mojo(name="protoc", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ProtocMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private File[] imports;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/java")
    private File output;
    @Parameter(required=true)
    private FileSet source;
    @Parameter(defaultValue="protoc")
    private String protocCommand;
    @Parameter(required=true)
    private String protocVersion;

    public void execute() throws MojoExecutionException {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.protocCommand);
            command.add("--version");
            Exec exec = new Exec((Mojo)this);
            ArrayList out = new ArrayList();
            if (exec.run(command, out) == 127) {
                this.getLog().error((CharSequence)("protoc, not found at: " + this.protocCommand));
                throw new MojoExecutionException("protoc failure");
            }
            if (out.isEmpty()) {
                this.getLog().error((CharSequence)("stdout: " + out));
                throw new MojoExecutionException("'protoc --version' did not return a version");
            }
            if (!((String)out.get(0)).endsWith(this.protocVersion)) {
                throw new MojoExecutionException("protoc version is '" + (String)out.get(0) + "', expected version is '" + this.protocVersion + "'");
            }
            if (!this.output.mkdirs() && !this.output.exists()) {
                throw new MojoExecutionException("Could not create directory: " + this.output);
            }
            command = new ArrayList();
            command.add(this.protocCommand);
            command.add("--java_out=" + this.output.getCanonicalPath());
            if (this.imports != null) {
                for (File i : this.imports) {
                    command.add("-I" + i.getCanonicalPath());
                }
            }
            for (File f : FileSetUtils.convertFileSetToFiles((FileSet)this.source)) {
                command.add(f.getCanonicalPath());
            }
            exec = new Exec((Mojo)this);
            out = new ArrayList();
            if (exec.run(command, out) != 0) {
                this.getLog().error((CharSequence)"protoc compiler error");
                for (String s : out) {
                    this.getLog().error((CharSequence)s);
                }
                throw new MojoExecutionException("protoc failure");
            }
        }
        catch (Throwable ex) {
            throw new MojoExecutionException(ex.toString(), ex);
        }
        this.project.addCompileSourceRoot(this.output.getAbsolutePath());
    }
}

