/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.util;

import java.util.List;
import org.apache.hadoop.maven.plugin.util.Exec;
import org.apache.maven.plugin.Mojo;

public class Exec {
    private Mojo mojo;

    public Exec(Mojo mojo) {
        this.mojo = mojo;
    }

    public int run(List<String> command, List<String> output) {
        int retCode = 1;
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            Process p = pb.start();
            OutputBufferThread stdOut = new OutputBufferThread(p.getInputStream());
            OutputBufferThread stdErr = new OutputBufferThread(p.getErrorStream());
            stdOut.start();
            stdErr.start();
            retCode = p.waitFor();
            if (retCode != 0) {
                this.mojo.getLog().warn((CharSequence)(command + " failed with error code " + retCode));
                for (String s : stdErr.getOutput()) {
                    this.mojo.getLog().debug((CharSequence)s);
                }
            }
            stdOut.join();
            stdErr.join();
            output.addAll(stdOut.getOutput());
        }
        catch (Exception ex) {
            this.mojo.getLog().warn((CharSequence)(command + " failed: " + ex.toString()));
        }
        return retCode;
    }
}

