/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalJobSubmission {
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));

    @Test
    public void testLocalJobLibjarsOption() throws IOException {
        Configuration conf = new Configuration();
        this.testLocalJobLibjarsOption(conf);
        conf.setBoolean("mapreduce.client.libjars.wildcard", false);
        this.testLocalJobLibjarsOption(conf);
    }

    private void testLocalJobLibjarsOption(Configuration conf) throws IOException {
        Path jarPath = this.makeJar(new Path(TEST_ROOT_DIR, "test.jar"));
        conf.set("fs.defaultFS", "hdfs://localhost:9000");
        conf.set("mapreduce.framework.name", "local");
        String[] args = new String[]{"-jt", "local", "-libjars", jarPath.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    @Test
    public void testLocalJobEncryptedIntermediateData() throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapreduce.framework.name", "local");
        conf.setBoolean("mapreduce.job.encrypted-intermediate-data", true);
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    @Test
    public void testJobMaxMapConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.framework.name", "local");
        conf.setInt("mapreduce.job.max.map", 0);
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
            Assert.fail((String)"Job should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("The number of map tasks 1 exceeded limit"));
        }
    }

    @Test
    public void testLocalJobFilesOption() throws IOException {
        Path jarPath = this.makeJar(new Path(TEST_ROOT_DIR, "test.jar"));
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hdfs://localhost:9000");
        conf.set("mapreduce.framework.name", "local");
        String[] args = new String[]{"-jt", "local", "-files", jarPath.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    @Test
    public void testLocalJobArchivesOption() throws IOException {
        Path jarPath = this.makeJar(new Path(TEST_ROOT_DIR, "test.jar"));
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hdfs://localhost:9000");
        conf.set("mapreduce.framework.name", "local");
        String[] args = new String[]{"-jt", "local", "-archives", jarPath.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    private Path makeJar(Path p) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(p.toString()));
        JarOutputStream jos = new JarOutputStream(fos);
        ZipEntry ze = new ZipEntry("test.jar.inside");
        jos.putNextEntry(ze);
        jos.write("inside the jar!".getBytes());
        jos.closeEntry();
        jos.close();
        return p;
    }
}

