/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.log4j.Level;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestUmbilicalProtocolWithJobToken {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestUmbilicalProtocolWithJobToken.class);
    private static Configuration conf = new Configuration();

    @Test
    public void testJobTokenRpc() throws Exception {
        TaskUmbilicalProtocol mockTT = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        ((TaskUmbilicalProtocol)Mockito.doReturn((Object)19L).when((Object)mockTT)).getProtocolVersion(Matchers.anyString(), Matchers.anyLong());
        ((TaskUmbilicalProtocol)Mockito.doReturn((Object)ProtocolSignature.getProtocolSignature((VersionedProtocol)mockTT, (String)TaskUmbilicalProtocol.class.getName(), (long)19L, (int)0)).when((Object)mockTT)).getProtocolSignature(Matchers.anyString(), Matchers.anyLong(), Matchers.anyInt());
        JobTokenSecretManager sm = new JobTokenSecretManager();
        RPC.Server server = RPC.getServer(TaskUmbilicalProtocol.class, (Object)mockTT, (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        String jobId = current.getUserName();
        JobTokenIdentifier tokenId = new JobTokenIdentifier(new Text(jobId));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        sm.addTokenForJob(jobId, token);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        LOG.info((Object)("Service address for token is " + token.getService()));
        current.addToken(token);
        current.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Configuration access$000() {
        return conf;
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
    }
}

