/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNetworkedJob {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private static Path testDir = new Path(TEST_ROOT_DIR + "/test_mini_mr_local");
    private static Path inFile = new Path(testDir, "in");
    private static Path outDir = new Path(testDir, "out");

    @Test
    public void testGetNullCounters() throws Exception {
        Job mockJob = (Job)Mockito.mock(Job.class);
        JobClient.NetworkedJob underTest = new JobClient.NetworkedJob(mockJob);
        Mockito.when((Object)mockJob.getCounters()).thenReturn(null);
        Assert.assertNull((Object)underTest.getCounters());
        ((Job)Mockito.verify((Object)mockJob)).getCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetJobStatus() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        try {
            mr = MiniMRClientClusterFactory.create(this.getClass(), (int)2, (Configuration)new Configuration());
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            RunningJob rj = client.submitJob(job);
            JobID jobId = rj.getID();
            Assert.assertEquals((String)"Expected matching JobIDs", (Object)jobId, (Object)client.getJob(jobId).getJobStatus().getJobID());
            Assert.assertEquals((String)"Expected matching startTimes", (long)rj.getJobStatus().getStartTime(), (long)client.getJob(jobId).getJobStatus().getStartTime());
        }
        finally {
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }
}

