/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.JobCounter;
import org.junit.Ignore;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class TestMultipleLevelCaching
extends TestCase {
    private static final int MAX_LEVEL = 5;
    final Path inDir = new Path("/cachetesting");
    final Path outputPath = new Path("/output");

    private static String getRack(int id, int level) {
        int length;
        StringBuilder rack = new StringBuilder();
        char alpha = 'a';
        for (length = level + 1; length > level; --length) {
            rack.append("/");
            rack.append(alpha);
            alpha = (char)(alpha + '\u0001');
        }
        while (length > 0) {
            rack.append("/");
            rack.append(alpha);
            rack.append(id);
            alpha = (char)(alpha + '\u0001');
            --length;
        }
        return rack.toString();
    }

    public void testMultiLevelCaching() throws Exception {
        for (int i = 1; i <= 5; ++i) {
            this.testCachingAtLevel(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCachingAtLevel(int level) throws Exception {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        String testName = "TestMultiLevelCaching";
        try {
            boolean taskTrackers = true;
            String rack1 = TestMultipleLevelCaching.getRack((int)0, (int)level);
            String rack2 = TestMultipleLevelCaching.getRack((int)1, (int)level);
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 1, true, new String[]{rack1}, new String[]{"host1.com"});
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            UtilsForTests.writeFile((NameNode)dfs.getNameNode(), (Configuration)conf, (Path)new Path(this.inDir + "/file"), (short)1);
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            JobConf jc = new JobConf();
            jc.setInt("mapreduce.jobtracker.taskcache.levels", level + 2);
            mr = new MiniMRCluster(1, namenode, 1, new String[]{rack2}, new String[]{"host2.com"}, jc);
            TestMultipleLevelCaching.launchJobAndTestCounters((String)testName, (MiniMRCluster)mr, (FileSystem)fileSys, (Path)this.inDir, (Path)this.outputPath, (int)1, (int)1, (int)0, (int)0);
            mr.shutdown();
        }
        finally {
            if (null != fileSys) {
                fileSys.delete(this.inDir, true);
                fileSys.delete(this.outputPath, true);
            }
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static void launchJobAndTestCounters(String jobName, MiniMRCluster mr, FileSystem fileSys, Path in, Path out, int numMaps, int otherLocalMaps, int dataLocalMaps, int rackLocalMaps) throws IOException {
        JobConf jobConf = mr.createJobConf();
        if (fileSys.exists(out)) {
            fileSys.delete(out, true);
        }
        RunningJob job = TestMultipleLevelCaching.launchJob((JobConf)jobConf, (Path)in, (Path)out, (int)numMaps, (String)jobName);
        Counters counters = job.getCounters();
        TestMultipleLevelCaching.assertEquals((String)"Number of local maps", (long)counters.getCounter((Enum)JobCounter.OTHER_LOCAL_MAPS), (long)otherLocalMaps);
        TestMultipleLevelCaching.assertEquals((String)"Number of Data-local maps", (long)counters.getCounter((Enum)JobCounter.DATA_LOCAL_MAPS), (long)dataLocalMaps);
        TestMultipleLevelCaching.assertEquals((String)"Number of Rack-local maps", (long)counters.getCounter((Enum)JobCounter.RACK_LOCAL_MAPS), (long)rackLocalMaps);
        mr.waitUntilIdle();
        mr.shutdown();
    }

    static RunningJob launchJob(JobConf jobConf, Path inDir, Path outputPath, int numMaps, String jobName) throws IOException {
        jobConf.setJobName(jobName);
        jobConf.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setMapperClass(IdentityMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setNumReduceTasks(0);
        jobConf.setJar("build/test/mapred/testjar/testjob.jar");
        return JobClient.runJob((JobConf)jobConf);
    }
}

