/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MultiFileSplit;
import org.apache.hadoop.mapred.TestMultiFileInputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMultiFileInputFormat
extends TestCase {
    private static JobConf job = new JobConf();
    private static final Log LOG = LogFactory.getLog(TestMultiFileInputFormat.class);
    private static final int MAX_SPLIT_COUNT = 10000;
    private static final int SPLIT_COUNT_INCR = 6000;
    private static final int MAX_BYTES = 1024;
    private static final int MAX_NUM_FILES = 10000;
    private static final int NUM_FILES_INCR = 8000;
    private Random rand = new Random(System.currentTimeMillis());
    private HashMap<String, Long> lengths = new HashMap();

    private Path initFiles(FileSystem fs, int numFiles, int numBytes) throws IOException {
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path multiFileDir = new Path(dir, "test.multifile");
        fs.delete(multiFileDir, true);
        fs.mkdirs(multiFileDir);
        LOG.info((Object)("Creating " + numFiles + " file(s) in " + multiFileDir));
        for (int i = 0; i < numFiles; ++i) {
            Path path = new Path(multiFileDir, "file_" + i);
            FSDataOutputStream out = fs.create(path);
            if (numBytes == -1) {
                numBytes = this.rand.nextInt(1024);
            }
            for (int j = 0; j < numBytes; ++j) {
                out.write(this.rand.nextInt());
            }
            out.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created file " + path + " with length " + numBytes));
            }
            this.lengths.put(path.getName(), new Long(numBytes));
        }
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{multiFileDir});
        return multiFileDir;
    }

    public void testFormat() throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Test started");
            LOG.info((Object)"Max split count           = 10000");
            LOG.info((Object)"Split count increment     = 6000");
            LOG.info((Object)"Max bytes per file        = 1024");
            LOG.info((Object)"Max number of files       = 10000");
            LOG.info((Object)"Number of files increment = 8000");
        }
        DummyMultiFileInputFormat format = new DummyMultiFileInputFormat(this, null);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        for (int numFiles = 1; numFiles < 10000; numFiles += 4000 + this.rand.nextInt(4000)) {
            Path dir = this.initFiles((FileSystem)fs, numFiles, -1);
            BitSet bits = new BitSet(numFiles);
            for (int i = 1; i < 10000; i += this.rand.nextInt(6000) + 1) {
                LOG.info((Object)("Running for Num Files=" + numFiles + ", split count=" + i));
                MultiFileSplit[] splits = (MultiFileSplit[])format.getSplits(job, i);
                bits.clear();
                for (MultiFileSplit split : splits) {
                    long splitLength = 0L;
                    for (Path p : split.getPaths()) {
                        long length = fs.getContentSummary(p).getLength();
                        TestMultiFileInputFormat.assertEquals((long)length, (long)((Long)this.lengths.get(p.getName())));
                        splitLength += length;
                        String name = p.getName();
                        int index = Integer.parseInt(name.substring(name.lastIndexOf("file_") + 5));
                        TestMultiFileInputFormat.assertFalse((boolean)bits.get(index));
                        bits.set(index);
                    }
                    TestMultiFileInputFormat.assertEquals((long)splitLength, (long)split.getLength());
                }
            }
            TestMultiFileInputFormat.assertEquals((int)bits.cardinality(), (int)numFiles);
            fs.delete(dir, true);
        }
        LOG.info((Object)"Test Finished");
    }

    public void testFormatWithLessPathsThanSplits() throws Exception {
        DummyMultiFileInputFormat format = new DummyMultiFileInputFormat(this, null);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        this.initFiles((FileSystem)fs, 0, -1);
        TestMultiFileInputFormat.assertEquals((int)0, (int)format.getSplits(job, 2).length);
        this.initFiles((FileSystem)fs, 2, 500);
        TestMultiFileInputFormat.assertEquals((int)2, (int)format.getSplits(job, 4).length);
    }

    public static void main(String[] args) throws Exception {
        TestMultiFileInputFormat test = new TestMultiFileInputFormat();
        test.testFormat();
    }
}

