/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.TestBlockLimits;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestBlockLimits
extends TestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithLimits() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRClientCluster mr = null;
        try {
            mr = MiniMRClientClusterFactory.create(this.getClass(), (int)2, (Configuration)new Configuration());
            this.runCustomFormat(mr);
        }
        finally {
            if (mr != null) {
                mr.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomFormat(MiniMRClientCluster mr) throws IOException {
        JobConf job = new JobConf(mr.getConfig());
        FileSystem fileSys = FileSystem.get((Configuration)job);
        Path testDir = new Path(TEST_ROOT_DIR + "/test_mini_mr_local");
        Path outDir = new Path(testDir, "out");
        System.out.println("testDir= " + testDir);
        fileSys.delete(testDir, true);
        job.setInputFormat(MyInputFormat.class);
        job.setOutputFormat(MyOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        job.setNumMapTasks(100);
        job.setNumReduceTasks(1);
        job.set("non.std.out", outDir.toString());
        try {
            JobClient.runJob((JobConf)job);
            TestBlockLimits.assertTrue((boolean)false);
        }
        catch (IOException ie) {
            System.out.println("Failed job " + StringUtils.stringifyException((Throwable)ie));
        }
        finally {
            fileSys.delete(testDir, true);
        }
    }
}

