/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.DistributedFSCheck;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.junit.Ignore;

@Ignore
public class DistributedFSCheck
extends TestCase {
    private static final Log LOG = LogFactory.getLog(DistributedFSCheck.class);
    private static final int TEST_TYPE_READ = 0;
    private static final int TEST_TYPE_CLEANUP = 2;
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final String DEFAULT_RES_FILE_NAME = "DistributedFSCheck_results.log";
    private static final long MEGA = 0x100000L;
    private static Configuration fsConfig = new Configuration();
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/benchmarks/DistributedFSCheck"));
    private static Path MAP_INPUT_DIR = new Path(TEST_ROOT_DIR, "map_input");
    private static Path READ_DIR = new Path(TEST_ROOT_DIR, "io_read");
    private FileSystem fs;
    private long nrFiles;

    DistributedFSCheck(Configuration conf) throws Exception {
        fsConfig = conf;
        this.fs = FileSystem.get((Configuration)conf);
    }

    public void testFSBlocks() throws Exception {
        this.testFSBlocks("/");
    }

    public void testFSBlocks(String rootName) throws Exception {
        this.createInputFile(rootName);
        this.runDistributedFSCheck();
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInputFile(String rootName) throws IOException {
        this.cleanup();
        Path inputFile = new Path(MAP_INPUT_DIR, "in_file");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)fsConfig, (Path)inputFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        try {
            this.nrFiles = 0L;
            this.listSubtree(new Path(rootName), writer);
        }
        finally {
            writer.close();
        }
        LOG.info((Object)"Created map input files.");
    }

    private void listSubtree(Path rootFile, SequenceFile.Writer writer) throws IOException {
        FileStatus rootStatus = this.fs.getFileStatus(rootFile);
        this.listSubtree(rootStatus, writer);
    }

    private void listSubtree(FileStatus rootStatus, SequenceFile.Writer writer) throws IOException {
        Path rootFile = rootStatus.getPath();
        if (rootStatus.isFile()) {
            ++this.nrFiles;
            long blockSize = this.fs.getDefaultBlockSize(rootFile);
            long fileLength = rootStatus.getLen();
            for (long offset = 0L; offset < fileLength; offset += blockSize) {
                writer.append((Writable)new Text(rootFile.toString()), (Writable)new LongWritable(offset));
            }
            return;
        }
        FileStatus[] children = null;
        try {
            children = this.fs.listStatus(rootFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Could not get listing for " + rootFile);
        }
        for (int i = 0; i < children.length; ++i) {
            this.listSubtree(children[i], writer);
        }
    }

    private void runDistributedFSCheck() throws Exception {
        JobConf job = new JobConf(this.fs.getConf(), DistributedFSCheck.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{MAP_INPUT_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(DistributedFSCheckMapper.class);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)READ_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    public static void main(String[] args) throws Exception {
        int testType = 0;
        int bufferSize = 1000000;
        String resFileName = DEFAULT_RES_FILE_NAME;
        String rootName = "/";
        boolean viewStats = false;
        String usage = "Usage: DistributedFSCheck [-root name] [-clean] [-resFile resultFileName] [-bufferSize Bytes] [-stats] ";
        if (args.length == 1 && args[0].startsWith("-h")) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-root")) {
                rootName = args[++i];
                continue;
            }
            if (args[i].startsWith("-clean")) {
                testType = 2;
                continue;
            }
            if (args[i].equals("-bufferSize")) {
                bufferSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-resFile")) {
                resFileName = args[++i];
                continue;
            }
            if (!args[i].startsWith("-stat")) continue;
            viewStats = true;
        }
        LOG.info((Object)("root = " + rootName));
        LOG.info((Object)("bufferSize = " + bufferSize));
        Configuration conf = new Configuration();
        conf.setInt("test.io.file.buffer.size", bufferSize);
        DistributedFSCheck test = new DistributedFSCheck(conf);
        if (testType == 2) {
            test.cleanup();
            return;
        }
        test.createInputFile(rootName);
        long tStart = System.currentTimeMillis();
        test.runDistributedFSCheck();
        long execTime = System.currentTimeMillis() - tStart;
        test.analyzeResult(execTime, resFileName, viewStats);
    }

    private void analyzeResult(long execTime, String resFileName, boolean viewStats) throws IOException {
        String line;
        Path reduceFile = new Path(READ_DIR, "part-00000");
        DataInputStream in = new DataInputStream((InputStream)this.fs.open(reduceFile));
        BufferedReader lines = new BufferedReader(new InputStreamReader(in));
        long blocks = 0L;
        long size = 0L;
        long time = 0L;
        float rate = 0.0f;
        StringTokenizer badBlocks = null;
        long nrBadBlocks = 0L;
        while ((line = lines.readLine()) != null) {
            StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
            String attr = tokens.nextToken();
            if (attr.endsWith("blocks")) {
                blocks = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith("size")) {
                size = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith("time")) {
                time = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith("rate")) {
                rate = Float.parseFloat(tokens.nextToken());
                continue;
            }
            if (!attr.endsWith("badBlocks")) continue;
            badBlocks = new StringTokenizer(tokens.nextToken(), ";");
            nrBadBlocks = badBlocks.countTokens();
        }
        Vector<String> resultLines = new Vector<String>();
        resultLines.add("----- DistributedFSCheck ----- : ");
        resultLines.add("               Date & time: " + new Date(System.currentTimeMillis()));
        resultLines.add("    Total number of blocks: " + blocks);
        resultLines.add("    Total number of  files: " + this.nrFiles);
        resultLines.add("Number of corrupted blocks: " + nrBadBlocks);
        int nrBadFilesPos = resultLines.size();
        TreeSet<String> badFiles = new TreeSet<String>();
        long nrBadFiles = 0L;
        if (nrBadBlocks > 0L) {
            resultLines.add("");
            resultLines.add("----- Corrupted Blocks (file@offset) ----- : ");
            while (badBlocks.hasMoreTokens()) {
                String curBlock = badBlocks.nextToken();
                resultLines.add(curBlock);
                badFiles.add(curBlock.substring(0, curBlock.indexOf(64)));
            }
            nrBadFiles = badFiles.size();
        }
        resultLines.insertElementAt(" Number of corrupted files: " + nrBadFiles, nrBadFilesPos);
        if (viewStats) {
            resultLines.add("");
            resultLines.add("-----   Performance  ----- : ");
            resultLines.add("         Total MBytes read: " + size / 0x100000L);
            resultLines.add("         Throughput mb/sec: " + (double)size * 1000.0 / (double)(time * 0x100000L));
            resultLines.add("    Average IO rate mb/sec: " + rate / 1000.0f / (float)blocks);
            resultLines.add("        Test exec time sec: " + (float)execTime / 1000.0f);
        }
        PrintStream res = new PrintStream(new FileOutputStream(new File(resFileName), true));
        for (int i = 0; i < resultLines.size(); ++i) {
            String cur = (String)resultLines.get(i);
            LOG.info((Object)cur);
            res.println(cur);
        }
    }

    private void cleanup() throws IOException {
        LOG.info((Object)"Cleaning up test files");
        this.fs.delete(TEST_ROOT_DIR, true);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

