/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.mapreduce.security.token.TestDelegationTokenRenewal;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class TestDelegationTokenRenewal {
    private static final Log LOG = LogFactory.getLog(TestDelegationTokenRenewal.class);
    private static final Text KIND = new Text("TestDelegationTokenRenewal.Token");
    private static Configuration conf;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        URI uri = new URI("hdfs://localhost:0");
        System.out.println("scheme is : " + uri.getScheme());
        conf.setClass("fs." + uri.getScheme() + ".impl", MyFS.class, DistributedFileSystem.class);
        FileSystem.setDefaultUri((Configuration)conf, (URI)uri);
        LOG.info((Object)("filesystem uri = " + FileSystem.getDefaultUri((Configuration)conf).toString()));
    }

    static MyToken createTokens(Text renewer) throws IOException {
        Text user1 = new Text("user1");
        MyDelegationTokenSecretManager sm = new MyDelegationTokenSecretManager(86400000L, 86400000L, 604800000L, 3600000L, null);
        sm.startThreads();
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(user1, renewer, user1);
        MyToken token1 = new MyToken(dtId1, sm);
        token1.setService(new Text("localhost:0"));
        return token1;
    }

    @Test
    public void testDTRenewal() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(dfs.hashCode()) + ";conf=" + conf.hashCode()));
        MyToken token1 = dfs.getDelegationToken(new Text("user1"));
        MyToken token2 = dfs.getDelegationToken(new Text("user2"));
        MyToken token3 = dfs.getDelegationToken(new Text("user3"));
        Renewer.access$202((Token)token1);
        LOG.info((Object)("token=" + token1 + " should be renewed for 2 secs"));
        String nn1 = "hdfs://host1:0";
        String nn2 = "hdfs://host2:0";
        String nn3 = "hdfs://host3:0";
        Credentials ts = new Credentials();
        ts.addToken(new Text(nn1), (Token)token1);
        ts.addToken(new Text(nn2), (Token)token2);
        ts.addToken(new Text(nn3), (Token)token3);
        DelegationTokenRenewal.registerDelegationTokensForRenewal((JobID)new JobID("job1", 1), (Credentials)ts, (Configuration)conf);
        int numberOfExpectedRenewals = 4;
        int attempts = 10;
        while (attempts-- > 0) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (Renewer.access$300() != numberOfExpectedRenewals) continue;
        }
        Assert.assertEquals((String)"renew wasn't called as many times as expected(4):", (long)numberOfExpectedRenewals, (long)Renewer.access$300());
        Assert.assertEquals((String)"most recently renewed token mismatch", (Object)Renewer.access$400(), (Object)token1);
        ts = new Credentials();
        MyToken token4 = dfs.getDelegationToken(new Text("user4"));
        Renewer.access$202((Token)token4);
        LOG.info((Object)("token=" + token4 + " should be renewed for 2 secs"));
        String nn4 = "hdfs://host4:0";
        ts.addToken(new Text(nn4), (Token)token4);
        JobID jid2 = new JobID("job2", 1);
        DelegationTokenRenewal.registerDelegationTokensForRenewal((JobID)jid2, (Credentials)ts, (Configuration)conf);
        DelegationTokenRenewal.removeDelegationTokenRenewalForJob((JobID)jid2);
        numberOfExpectedRenewals = Renewer.access$300();
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("Counter = " + Renewer.access$300() + ";t=" + Renewer.access$400());
        Assert.assertEquals((String)"renew wasn't called as many times as expected", (long)numberOfExpectedRenewals, (long)Renewer.access$300());
        try {
            token4.renew(conf);
            Assert.fail((String)"Renew of canceled token didn't fail");
        }
        catch (SecretManager.InvalidToken ite) {
            // empty catch block
        }
    }

    static /* synthetic */ Text access$000() {
        return KIND;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

