/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TestJobOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJobOutputCommitter
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp") + "/" + "test-job-cleanup").toString();
    private static final String CUSTOM_CLEANUP_FILE_NAME = "_custom_cleanup";
    private static final String ABORT_KILLED_FILE_NAME = "_custom_abort_killed";
    private static final String ABORT_FAILED_FILE_NAME = "_custom_abort_failed";
    private static Path inDir = new Path(TEST_ROOT_DIR, "test-input");
    private static int outDirs = 0;
    private FileSystem fs;
    private Configuration conf = null;

    public TestJobOutputCommitter() throws IOException {
        super(2, 4, 1, 1);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.conf = this.createJobConf();
        this.fs = this.getFileSystem();
    }

    protected void tearDown() throws Exception {
        this.fs.delete(new Path(TEST_ROOT_DIR), true);
        super.tearDown();
    }

    private Path getNewOutputDir() {
        return new Path(TEST_ROOT_DIR, "output-" + outDirs++);
    }

    private void testSuccessfulJob(String filename, Class<? extends OutputFormat> output, String[] exclude) throws Exception {
        Path outDir = this.getNewOutputDir();
        Job job = MapReduceTestUtil.createJob((Configuration)this.conf, (Path)inDir, (Path)outDir, (int)1, (int)0);
        job.setOutputFormatClass(output);
        TestJobOutputCommitter.assertTrue((String)"Job failed!", (boolean)job.waitForCompletion(true));
        Path testFile = new Path(outDir, filename);
        TestJobOutputCommitter.assertTrue((String)("Done file missing for job " + job.getJobID()), (boolean)this.fs.exists(testFile));
        for (String ex : exclude) {
            Path file = new Path(outDir, ex);
            TestJobOutputCommitter.assertFalse((String)("File " + file + " should not be present for successful job " + job.getJobID()), (boolean)this.fs.exists(file));
        }
    }

    private void testFailedJob(String fileName, Class<? extends OutputFormat> output, String[] exclude) throws Exception {
        Path outDir = this.getNewOutputDir();
        Job job = MapReduceTestUtil.createFailJob((Configuration)this.conf, (Path)outDir, (Path[])new Path[]{inDir});
        job.setOutputFormatClass(output);
        TestJobOutputCommitter.assertFalse((String)"Job did not fail!", (boolean)job.waitForCompletion(true));
        if (fileName != null) {
            Path testFile = new Path(outDir, fileName);
            TestJobOutputCommitter.assertTrue((String)("File " + testFile + " missing for failed job " + job.getJobID()), (boolean)this.fs.exists(testFile));
        }
        for (String ex : exclude) {
            Path file = new Path(outDir, ex);
            TestJobOutputCommitter.assertFalse((String)("File " + file + " should not be present for failed job " + job.getJobID()), (boolean)this.fs.exists(file));
        }
    }

    private void testKilledJob(String fileName, Class<? extends OutputFormat> output, String[] exclude) throws Exception {
        Path outDir = this.getNewOutputDir();
        Job job = MapReduceTestUtil.createKillJob((Configuration)this.conf, (Path)outDir, (Path[])new Path[]{inDir});
        job.setOutputFormatClass(output);
        job.submit();
        while (job.setupProgress() != 1.0f) {
            UtilsForTests.waitFor((long)100L);
        }
        job.killJob();
        TestJobOutputCommitter.assertFalse((String)"Job did not get kill", (boolean)job.waitForCompletion(true));
        if (fileName != null) {
            Path testFile = new Path(outDir, fileName);
            TestJobOutputCommitter.assertTrue((String)("File " + testFile + " missing for job " + job.getJobID()), (boolean)this.fs.exists(testFile));
        }
        for (String ex : exclude) {
            Path file = new Path(outDir, ex);
            TestJobOutputCommitter.assertFalse((String)("File " + file + " should not be present for killed job " + job.getJobID()), (boolean)this.fs.exists(file));
        }
    }

    public void testDefaultCleanupAndAbort() throws Exception {
        this.testSuccessfulJob("_SUCCESS", TextOutputFormat.class, new String[0]);
        this.testFailedJob(null, TextOutputFormat.class, new String[]{"_SUCCESS"});
        this.testKilledJob(null, TextOutputFormat.class, new String[]{"_SUCCESS"});
    }

    public void testCustomAbort() throws Exception {
        this.testSuccessfulJob("_SUCCESS", MyOutputFormatWithCustomAbort.class, new String[]{"_custom_abort_failed", "_custom_abort_killed"});
        this.testFailedJob("_custom_abort_failed", MyOutputFormatWithCustomAbort.class, new String[]{"_SUCCESS", "_custom_abort_killed"});
        this.testKilledJob("_custom_abort_killed", MyOutputFormatWithCustomAbort.class, new String[]{"_SUCCESS", "_custom_abort_failed"});
    }

    public void testCustomCleanup() throws Exception {
        this.testSuccessfulJob("_custom_cleanup", MyOutputFormatWithCustomCleanup.class, new String[0]);
        this.testFailedJob("_custom_cleanup", MyOutputFormatWithCustomCleanup.class, new String[]{"_SUCCESS"});
        this.testKilledJob("_custom_cleanup", MyOutputFormatWithCustomCleanup.class, new String[]{"_SUCCESS"});
    }
}

