/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.DelegatingInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.MultipleInputs;
import org.apache.hadoop.mapreduce.lib.input.TaggedInputSplit;
import org.apache.hadoop.mapreduce.lib.input.TestDelegatingInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDelegatingInputFormat
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitting() throws Exception {
        Job job = Job.getInstance();
        MiniDFSCluster dfs = null;
        try {
            dfs = new MiniDFSCluster(job.getConfiguration(), 4, true, new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}, new String[]{"host0", "host1", "host2", "host3"});
            FileSystem fs = dfs.getFileSystem();
            Path path = TestDelegatingInputFormat.getPath((String)"/foo/bar", (FileSystem)fs);
            Path path2 = TestDelegatingInputFormat.getPath((String)"/foo/baz", (FileSystem)fs);
            Path path3 = TestDelegatingInputFormat.getPath((String)"/bar/bar", (FileSystem)fs);
            Path path4 = TestDelegatingInputFormat.getPath((String)"/bar/baz", (FileSystem)fs);
            int numSplits = 100;
            FileInputFormat.setMaxInputSplitSize((Job)job, (long)(fs.getFileStatus(path).getLen() / 100L));
            MultipleInputs.addInputPath((Job)job, (Path)path, TextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((Job)job, (Path)path2, TextInputFormat.class, MapClass2.class);
            MultipleInputs.addInputPath((Job)job, (Path)path3, KeyValueTextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((Job)job, (Path)path4, TextInputFormat.class, MapClass2.class);
            DelegatingInputFormat inFormat = new DelegatingInputFormat();
            int[] bins = new int[3];
            for (InputSplit split : inFormat.getSplits((JobContext)job)) {
                TestDelegatingInputFormat.assertTrue((boolean)(split instanceof TaggedInputSplit));
                TaggedInputSplit tis = (TaggedInputSplit)split;
                int index = -1;
                index = tis.getInputFormatClass().equals(KeyValueTextInputFormat.class) ? 0 : (tis.getMapperClass().equals(MapClass.class) ? 1 : 2);
                int n = index;
                bins[n] = bins[n] + 1;
            }
            TestDelegatingInputFormat.assertEquals((String)"count is not equal to num splits", (int)100, (int)bins[0]);
            TestDelegatingInputFormat.assertEquals((String)"count is not equal to num splits", (int)100, (int)bins[1]);
            TestDelegatingInputFormat.assertEquals((String)"count is not equal to 2 * num splits", (int)200, (int)bins[2]);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static Path getPath(String location, FileSystem fs) throws IOException {
        Path path = new Path(location);
        FSDataOutputStream out = fs.create(path, true, 4096, (short)2, 512L, null);
        for (int i = 0; i < 1000; ++i) {
            out.writeChars("Hello\n");
        }
        out.close();
        return path;
    }
}

