/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TestCombineFileInputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCombineFileInputFormat
extends TestCase {
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};
    private static final String[] rack2 = new String[]{"/r2"};
    private static final String[] hosts2 = new String[]{"host2.rack2.com"};
    private static final String[] rack3 = new String[]{"/r3"};
    private static final String[] hosts3 = new String[]{"host3.rack3.com"};
    final Path inDir = new Path("/racktesting");
    final Path outputPath = new Path("/output");
    final Path dir1 = new Path(this.inDir, "/dir1");
    final Path dir2 = new Path(this.inDir, "/dir2");
    final Path dir3 = new Path(this.inDir, "/dir3");
    final Path dir4 = new Path(this.inDir, "/dir4");
    final Path dir5 = new Path(this.inDir, "/dir5");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    private static final String DUMMY_FS_URI = "dummyfs:///";
    private static final String DUMMY_KEY = "dummy.rr.key";

    public void testRecordReaderInit() throws InterruptedException, IOException {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, TaskType.MAP, 0, 0);
        Configuration conf1 = new Configuration();
        conf1.set("dummy.rr.key", "STATE1");
        TaskAttemptContextImpl context1 = new TaskAttemptContextImpl(conf1, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat(this, null);
        Path[] files = new Path[]{new Path("file1")};
        long[] lengths = new long[]{1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, (TaskAttemptContext)context1);
        TestCombineFileInputFormat.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        TestCombineFileInputFormat.assertEquals((String)"Invalid initial dummy key value", (String)"STATE1", (String)rr.getCurrentKey().toString());
        Configuration conf2 = new Configuration();
        conf2.set("dummy.rr.key", "STATE2");
        TaskAttemptContextImpl context2 = new TaskAttemptContextImpl(conf2, taskId);
        rr.initialize((InputSplit)split, (TaskAttemptContext)context2);
        TestCombineFileInputFormat.assertEquals((String)"Invalid secondary dummy key value", (String)"STATE2", (String)rr.getCurrentKey().toString());
    }

    public void testReinit() throws Exception {
        TaskAttemptID taskId = new TaskAttemptID("jt", 0, TaskType.MAP, 0, 0);
        Configuration conf = new Configuration();
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, taskId);
        ChildRRInputFormat inputFormat = new ChildRRInputFormat(this, null);
        Path[] files = new Path[]{new Path("file1"), new Path("file2")};
        long[] lengths = new long[]{1L, 1L};
        CombineFileSplit split = new CombineFileSplit(files, lengths);
        RecordReader rr = inputFormat.createRecordReader((InputSplit)split, (TaskAttemptContext)context);
        TestCombineFileInputFormat.assertTrue((String)"Unexpected RR type!", (boolean)(rr instanceof CombineFileRecordReader));
        rr.initialize((InputSplit)split, (TaskAttemptContext)context);
        TestCombineFileInputFormat.assertTrue((boolean)rr.nextKeyValue());
        TestCombineFileInputFormat.assertEquals((String)"file1", (String)rr.getCurrentValue().toString());
        TestCombineFileInputFormat.assertTrue((boolean)rr.nextKeyValue());
        TestCombineFileInputFormat.assertEquals((String)"file2", (String)rr.getCurrentValue().toString());
        TestCombineFileInputFormat.assertFalse((boolean)rr.nextKeyValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitPlacement() throws IOException {
        MiniDFSCluster dfs = null;
        FileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file1, (short)1, (int)1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file5, (short)1, (int)1);
            DummyInputFormat inFormat = new DummyInputFormat(this, null);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)1, (int)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file5.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file2, (short)2, (int)2);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test1): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)2, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)new Path(this.dir3 + "/file3"), (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test2): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)3, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(2).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            Path file4 = new Path(this.dir4 + "/file4");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file4, (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(1024L);
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test3): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)6, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(2).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(2048L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)5, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)"host3.rack3.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)"host3.rack3.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)"host3.rack3.com", (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(1024L);
            inFormat.setMaxSplitSize(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test5): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)4, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)3, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(2).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            TestCombineFileInputFormat.assertEquals((String)"host3.rack3.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(2).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            TestCombineFileInputFormat.assertEquals((String)"host3.rack3.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)"host2.rack2.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(3);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)"host1.rack1.com", (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(4096L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test6): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)4, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(2).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(2));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            TestCombineFileInputFormat.assertEquals((String)"host3.rack3.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)4, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(2).getName());
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getOffset(2));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(2));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(3).getName());
            TestCombineFileInputFormat.assertEquals((long)2048L, (long)fileSplit.getOffset(3));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(3));
            TestCombineFileInputFormat.assertEquals((String)"host2.rack2.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(7168L);
            inFormat.setMinSplitSizeNode(3072L);
            inFormat.setMinSplitSizeRack(3072L);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test7): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)2, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)6, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)"host3.rack3.com", (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)3, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)"host1.rack1.com", (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.addInputPath((Job)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)6, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1(this, null);
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits((JobContext)job);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools " + " and " + numFiles + " files is " + (end - start) / 1000L + " seconds.");
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(512L);
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.dir3});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test8): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)6);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        TestCombineFileInputFormat.writeDataAndSetReplication((FileSystem)fileSys, (Path)name, (OutputStream)stm, (short)replication, (int)numBlocks);
    }

    static FileStatus writeGzipFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        GZIPOutputStream out = new GZIPOutputStream((OutputStream)fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L));
        TestCombineFileInputFormat.writeDataAndSetReplication((FileSystem)fileSys, (Path)name, (OutputStream)out, (short)replication, (int)numBlocks);
        return fileSys.getFileStatus(name);
    }

    private static void writeDataAndSetReplication(FileSystem fileSys, Path name, OutputStream out, short replication, int numBlocks) throws IOException {
        for (int i = 0; i < numBlocks; ++i) {
            out.write(databuf);
        }
        out.close();
        DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitPlacementForCompressedFiles() throws IOException {
        MiniDFSCluster dfs = null;
        FileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1.gz");
            FileStatus f1 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file1, (short)1, (int)1);
            Path file5 = new Path(this.dir5 + "/file5.gz");
            FileStatus f5 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file5, (short)1, (int)1);
            DummyInputFormat inFormat = new DummyInputFormat(this, null);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)1, (int)splits.size());
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file5.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f5.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack2, hosts2, null);
            dfs.waitActive();
            Path file2 = new Path(this.dir2 + "/file2.gz");
            FileStatus f2 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file2, (short)2, (int)2);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test1): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test1): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)2, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            dfs.startDataNodes(conf, 1, true, null, rack3, hosts3, null);
            dfs.waitActive();
            Path file3 = new Path(this.dir3 + "/file3.gz");
            FileStatus f3 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file3, (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test2): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            Path file4 = new Path(this.dir4 + "/file4.gz");
            FileStatus f4 = TestCombineFileInputFormat.writeGzipFile((Configuration)conf, (Path)file4, (short)3, (int)3);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            inFormat.setMinSplitSizeRack(f1.getLen());
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test3): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test4): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)4, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(3);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(f1.getLen());
            inFormat.setMaxSplitSize(2L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test5): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(2L * f1.getLen());
            inFormat.setMaxSplitSize(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test6): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)2, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file3.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f3.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file4.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)f4.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)f1.getLen(), (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file2.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((float)0.0f, (float)fileSplit.getOffset(1), (float)1024.0f);
            TestCombineFileInputFormat.assertEquals((long)f2.getLen(), (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMaxSplitSize(4L * f1.getLen());
            inFormat.setMinSplitSizeRack(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test7): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)1, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)4, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            inFormat.setMinSplitSizeNode(4L * f1.getLen());
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir2 + "," + this.dir3 + "," + this.dir4));
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test8): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)1, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)4, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            inFormat = new DummyInputFormat(this, null);
            FileInputFormat.addInputPath((Job)job, (Path)this.inDir);
            inFormat.setMinSplitSizeRack(1L);
            inFormat.createPool(new PathFilter[]{new TestFilter(this.dir1), new TestFilter(this.dir2)});
            splits = inFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                System.out.println("File split(Test9): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)3, (int)splits.size());
            fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts2[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(1);
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
            fileSplit = (CombineFileSplit)splits.get(2);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)hosts3[0], (String)fileSplit.getLocations()[0]);
            int numPools = 100;
            int numFiles = 1000;
            DummyInputFormat1 inFormat1 = new DummyInputFormat1(this, null);
            for (int i = 0; i < numFiles; ++i) {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{file1});
            }
            inFormat1.setMinSplitSizeRack(1L);
            Path dirNoMatch1 = new Path(this.inDir, "/dirxx");
            Path dirNoMatch2 = new Path(this.inDir, "/diryy");
            for (int i = 0; i < numPools; ++i) {
                inFormat1.createPool(new PathFilter[]{new TestFilter(dirNoMatch1), new TestFilter(dirNoMatch2)});
            }
            long start = System.currentTimeMillis();
            splits = inFormat1.getSplits((JobContext)job);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time for " + numPools + " pools " + " and " + numFiles + " files is " + (end - start) + " milli seconds.");
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingBlocks() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        FileSystem fileSys = null;
        String testName = "testMissingBlocks";
        try {
            Configuration conf = new Configuration();
            conf.set("fs.hdfs.impl", MissingBlockFileSystem.class.getName());
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, rack1, hosts1);
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            fileSys = dfs.getFileSystem();
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            Path file1 = new Path(this.dir1 + "/file1");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file1, (short)1, (int)1);
            Path file5 = new Path(this.dir5 + "/file5");
            TestCombineFileInputFormat.writeFile((Configuration)conf, (Path)file5, (short)1, (int)1);
            ((MissingBlockFileSystem)fileSys).setFileWithMissingBlocks(file1.toUri().getPath());
            DummyInputFormat inFormat = new DummyInputFormat(this, null);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)(this.dir1 + "," + this.dir5));
            List splits = inFormat.getSplits((JobContext)job);
            System.out.println("Made splits(Test0): " + splits.size());
            for (InputSplit split : splits) {
                System.out.println("File split(Test0): " + split);
            }
            TestCombineFileInputFormat.assertEquals((int)splits.size(), (int)1);
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
            TestCombineFileInputFormat.assertEquals((int)2, (int)fileSplit.getNumPaths());
            TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getLocations().length);
            TestCombineFileInputFormat.assertEquals((String)file1.getName(), (String)fileSplit.getPath(0).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(0));
            TestCombineFileInputFormat.assertEquals((String)file5.getName(), (String)fileSplit.getPath(1).getName());
            TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(1));
            TestCombineFileInputFormat.assertEquals((long)1024L, (long)fileSplit.getLength(1));
            TestCombineFileInputFormat.assertEquals((String)hosts1[0], (String)fileSplit.getLocations()[0]);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    @Test
    public void testForNonDefaultFileSystem() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "dummyfs:///");
        TestCombineFileInputFormat.assertEquals((String)"dummyfs:///", (String)FileSystem.getDefaultUri((Configuration)conf).toString());
        Path localPath = new Path("testFile1");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        FSDataOutputStream dos = lfs.create(localPath);
        dos.writeChars("Local file for CFIF");
        dos.close();
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{lfs.makeQualified(localPath)});
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        List splits = inFormat.getSplits((JobContext)job);
        TestCombineFileInputFormat.assertTrue((splits.size() > 0 ? 1 : 0) != 0);
        for (InputSplit s : splits) {
            CombineFileSplit cfs = (CombineFileSplit)s;
            for (Path p : cfs.getPaths()) {
                TestCombineFileInputFormat.assertEquals((String)p.toUri().getScheme(), (String)"file");
            }
        }
    }

    @Test
    public void testForEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        Path file = new Path("test/file");
        FSDataOutputStream out = fileSys.create(file, true, conf.getInt("io.file.buffer.size", 4096), (short)1, 1024L);
        out.write(new byte[0]);
        out.close();
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)"test");
        List splits = inFormat.getSplits((JobContext)job);
        TestCombineFileInputFormat.assertEquals((int)1, (int)splits.size());
        CombineFileSplit fileSplit = (CombineFileSplit)splits.get(0);
        TestCombineFileInputFormat.assertEquals((int)1, (int)fileSplit.getNumPaths());
        TestCombineFileInputFormat.assertEquals((String)file.getName(), (String)fileSplit.getPath(0).getName());
        TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getOffset(0));
        TestCombineFileInputFormat.assertEquals((long)0L, (long)fileSplit.getLength(0));
        fileSys.delete(file.getParent(), true);
    }

    private void splitRealFiles(String[] args) throws IOException {
        Configuration conf = new Configuration();
        Job job = Job.getInstance();
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IOException("Wrong file system: " + fs.getClass().getName());
        }
        long blockSize = fs.getDefaultBlockSize();
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        for (int i = 0; i < args.length; ++i) {
            FileInputFormat.addInputPaths((Job)job, (String)args[i]);
        }
        inFormat.setMinSplitSizeRack(blockSize);
        inFormat.setMaxSplitSize(10L * blockSize);
        List splits = inFormat.getSplits((JobContext)job);
        System.out.println("Total number of splits " + splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            CombineFileSplit fileSplit = (CombineFileSplit)splits.get(i);
            System.out.println("Split[" + i + "] " + fileSplit);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.splitRealFiles(args);
        } else {
            TestCombineFileInputFormat test = new TestCombineFileInputFormat();
            test.testSplitPlacement();
        }
    }
}

