/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Ignore;
import testshell.ExternalMapReduce;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class TestCommandLineJobSubmission
extends TestCase {
    static final Path input = new Path("/test/input/");
    static final Path output = new Path("/test/output");
    File buildDir = new File(System.getProperty("test.build.data", "/tmp"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobShell() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fs = null;
        Path testFile = new Path(input, "testfile");
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 2, true, null);
            fs = dfs.getFileSystem();
            FSDataOutputStream stream = fs.create(testFile);
            stream.write("teststring".getBytes());
            stream.close();
            mr = new MiniMRCluster(2, fs.getUri().toString(), 1);
            File thisbuildDir = new File(this.buildDir, "jobCommand");
            TestCommandLineJobSubmission.assertTrue((String)"create build dir", (boolean)thisbuildDir.mkdirs());
            File f = new File(thisbuildDir, "files_tmp");
            FileOutputStream fstream = new FileOutputStream(f);
            fstream.write("somestrings".getBytes());
            fstream.close();
            File f1 = new File(thisbuildDir, "files_tmp1");
            fstream = new FileOutputStream(f1);
            fstream.write("somestrings".getBytes());
            fstream.close();
            Path cachePath = new Path("/cacheDir");
            if (!fs.mkdirs(cachePath)) {
                throw new IOException("Mkdirs failed to create " + cachePath.toString());
            }
            Path localCachePath = new Path(System.getProperty("test.cache.data"));
            Path txtPath = new Path(localCachePath, new Path("test.txt"));
            Path jarPath = new Path(localCachePath, new Path("test.jar"));
            Path zipPath = new Path(localCachePath, new Path("test.zip"));
            Path tarPath = new Path(localCachePath, new Path("test.tar"));
            Path tgzPath = new Path(localCachePath, new Path("test.tgz"));
            fs.copyFromLocalFile(txtPath, cachePath);
            fs.copyFromLocalFile(jarPath, cachePath);
            fs.copyFromLocalFile(zipPath, cachePath);
            String[] files = new String[]{f.toString(), f1.toString() + "#localfilelink", fs.getUri().resolve(cachePath + "/test.txt#dfsfilelink").toString()};
            String[] libjars = new String[]{"build/test/mapred/testjar/testjob.jar", fs.getUri().resolve(cachePath + "/test.jar").toString()};
            String[] archives = new String[]{tgzPath.toString(), tarPath + "#tarlink", fs.getUri().resolve(cachePath + "/test.zip#ziplink").toString()};
            String[] args = new String[]{"-files", StringUtils.arrayToString((String[])files), "-libjars", StringUtils.arrayToString((String[])libjars), "-archives", StringUtils.arrayToString((String[])archives), "-D", "mapred.output.committer.class=testjar.CustomOutputCommitter", input.toString(), output.toString()};
            JobConf jobConf = mr.createJobConf();
            TestCommandLineJobSubmission.assertTrue((String)"libjar not in client classpath", (this.loadLibJar(jobConf) == null ? 1 : 0) != 0);
            int ret = ToolRunner.run((Configuration)jobConf, (Tool)new ExternalMapReduce(), (String[])args);
            TestCommandLineJobSubmission.assertTrue((String)"libjar added to client classpath", (this.loadLibJar(jobConf) != null ? 1 : 0) != 0);
            TestCommandLineJobSubmission.assertTrue((String)"not failed ", (ret != -1 ? 1 : 0) != 0);
            f.delete();
            thisbuildDir.delete();
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    private Class loadLibJar(JobConf jobConf) {
        try {
            return jobConf.getClassByName("testjar.ClassWordCount");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

