/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapred.YARNRunner;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Test;
import org.mockito.Mockito;

public class TestYarnClientProtocolProvider
extends TestCase {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithYarnClientProtocolProvider() throws Exception {
        Configuration conf = new Configuration(false);
        Cluster cluster = null;
        try {
            cluster = new Cluster(conf);
            TestYarnClientProtocolProvider.fail((String)"Cluster should not be initialized with out any framework name");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            conf = new Configuration();
            conf.set("mapreduce.framework.name", "yarn");
            cluster = new Cluster(conf);
            ClientProtocol client = cluster.getClient();
            TestYarnClientProtocolProvider.assertTrue((boolean)(client instanceof YARNRunner));
        }
        catch (IOException iOException) {
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterGetDelegationToken() throws Exception {
        Configuration conf = new Configuration(false);
        Cluster cluster = null;
        try {
            conf = new Configuration();
            conf.set("mapreduce.framework.name", "yarn");
            cluster = new Cluster(conf);
            YARNRunner yrunner = (YARNRunner)cluster.getClient();
            GetDelegationTokenResponse getDTResponse = (GetDelegationTokenResponse)recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
            DelegationToken rmDTToken = (DelegationToken)recordFactory.newRecordInstance(DelegationToken.class);
            rmDTToken.setIdentifier(ByteBuffer.wrap(new byte[2]));
            rmDTToken.setKind("Testclusterkind");
            rmDTToken.setPassword(ByteBuffer.wrap("testcluster".getBytes()));
            rmDTToken.setService("0.0.0.0:8032");
            getDTResponse.setRMDelegationToken(rmDTToken);
            ClientRMProtocol cRMProtocol = (ClientRMProtocol)Mockito.mock(ClientRMProtocol.class);
            Mockito.when((Object)cRMProtocol.getDelegationToken((GetDelegationTokenRequest)Mockito.any(GetDelegationTokenRequest.class))).thenReturn((Object)getDTResponse);
            ResourceMgrDelegate rmgrDelegate = new ResourceMgrDelegate(new YarnConfiguration(conf), cRMProtocol);
            yrunner.setResourceMgrDelegate(rmgrDelegate);
            Token t = cluster.getDelegationToken(new Text(" "));
            TestYarnClientProtocolProvider.assertTrue((boolean)"Testclusterkind".equals(t.getKind().toString()));
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
    }
}

