/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestMiniMRClasspath;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Ignore;

@Ignore
public class TestMiniMRWithDFSWithDistinctUsers
extends TestCase {
    static final UserGroupInformation DFS_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("dfs", true);
    static final UserGroupInformation ALICE_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("alice", false);
    static final UserGroupInformation BOB_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("bob", false);
    MiniMRCluster mr = null;
    MiniDFSCluster dfs = null;
    FileSystem fs = null;
    Configuration conf = new Configuration();
    String jobTrackerName;

    static UserGroupInformation createUGI(String name, boolean issuper) {
        String group = issuper ? "supergroup" : name;
        return UserGroupInformation.createUserForTesting((String)name, (String[])new String[]{group});
    }

    static void mkdir(FileSystem fs, String dir, String user, String group, short mode) throws IOException {
        Path p = new Path(dir);
        fs.mkdirs(p);
        fs.setPermission(p, new FsPermission(mode));
        fs.setOwner(p, user, group);
    }

    void runJobAsUser(final JobConf job, UserGroupInformation ugi) throws Exception {
        RunningJob rj = (RunningJob)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RunningJob>(){

            @Override
            public RunningJob run() throws IOException {
                return JobClient.runJob((JobConf)job);
            }
        });
        rj.waitForCompletion();
        TestMiniMRWithDFSWithDistinctUsers.assertEquals((String)"SUCCEEDED", (String)JobStatus.getJobRunState((int)rj.getJobState()));
    }

    public void setUp() throws Exception {
        this.dfs = new MiniDFSCluster(this.conf, 4, true, null);
        this.fs = (FileSystem)DFS_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return TestMiniMRWithDFSWithDistinctUsers.this.dfs.getFileSystem();
            }
        });
        TestMiniMRWithDFSWithDistinctUsers.mkdir(this.fs, "/user", "nobody", "nogroup", (short)1023);
        TestMiniMRWithDFSWithDistinctUsers.mkdir(this.fs, "/user/alice", "alice", "nogroup", (short)493);
        TestMiniMRWithDFSWithDistinctUsers.mkdir(this.fs, "/user/bob", "bob", "nogroup", (short)493);
        UserGroupInformation MR_UGI = UserGroupInformation.getLoginUser();
        TestMiniMRWithDFSWithDistinctUsers.mkdir(this.fs, "/staging", MR_UGI.getShortUserName(), "nogroup", (short)1023);
        JobConf mrConf = new JobConf();
        mrConf.set("mapreduce.jobtracker.staging.root.dir", "/staging");
        this.mr = new MiniMRCluster(0, 0, 4, this.dfs.getFileSystem().getUri().toString(), 1, null, null, MR_UGI, mrConf);
        this.jobTrackerName = "localhost:" + this.mr.getJobTrackerPort();
    }

    public void tearDown() throws Exception {
        if (this.mr != null) {
            this.mr.shutdown();
        }
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
    }

    public void testDistinctUsers() throws Exception {
        JobConf job1 = this.mr.createJobConf();
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        Path inDir = new Path("/testing/distinct/input");
        Path outDir = new Path("/user/alice/output");
        TestMiniMRClasspath.configureWordCount(this.fs, this.jobTrackerName, job1, input, 2, 1, inDir, outDir);
        this.runJobAsUser(job1, ALICE_UGI);
        JobConf job2 = this.mr.createJobConf();
        Path inDir2 = new Path("/testing/distinct/input2");
        Path outDir2 = new Path("/user/bob/output2");
        TestMiniMRClasspath.configureWordCount(this.fs, this.jobTrackerName, job2, input, 2, 1, inDir2, outDir2);
        this.runJobAsUser(job2, BOB_UGI);
    }

    public void testMultipleSpills() throws Exception {
        JobConf job1 = this.mr.createJobConf();
        job1.setFloat("mapreduce.map.sort.spill.percent", 1.0E-4f);
        job1.setInt("mapreduce.task.io.sort.mb", 1);
        job1.setInt("mapreduce.task.index.cache.limit.bytes", 0);
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        Path inDir = new Path("/testing/distinct/input");
        Path outDir = new Path("/user/alice/output");
        TestMiniMRClasspath.configureWordCount(this.fs, this.jobTrackerName, job1, input, 2, 1, inDir, outDir);
        this.runJobAsUser(job1, ALICE_UGI);
    }
}

