/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.hs.MockHistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestHsWebServicesTasks;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestHsWebServicesTasks
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static MockHistoryContext appContext;
    private static HsWebApp webApp;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestHsWebServicesTasks() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.hs.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testTasks() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
            this.verifyHsTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
            this.verifyHsTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
            this.verifyHsTask(arr, (Job)jobsMap.get(id), null);
        }
    }

    @Test
    public void testTasksXML() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList tasks = dom.getElementsByTagName("tasks");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)tasks.getLength());
            NodeList task = dom.getElementsByTagName("task");
            this.verifyHsTaskXML(task, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testTasksQueryMap() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String type = "m";
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", type).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
            this.verifyHsTask(arr, (Job)jobsMap.get(id), type);
        }
    }

    @Test
    public void testTasksQueryReduce() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String type = "r";
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", type).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject tasks = json.getJSONObject("tasks");
            JSONArray arr = tasks.getJSONArray("task");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
            this.verifyHsTask(arr, (Job)jobsMap.get(id), type);
        }
    }

    @Test
    public void testTasksQueryInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tasktype = "reduce";
            try {
                r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").queryParam("type", tasktype).accept(new String[]{"application/json"}).get(JSONObject.class);
                Assert.fail((String)"should have thrown exception on invalid uri");
            }
            catch (UniformInterfaceException ue) {
                ClientResponse response = ue.getResponse();
                Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: tasktype must be either m or r", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskId() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).accept(new String[]{"application/json"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("task");
                this.verifyHsSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid + "/").accept(new String[]{"application/json"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("task");
                this.verifyHsSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("task");
                this.verifyHsSingleTask(info, task);
            }
        }
    }

    @Test
    public void testTaskIdBogus() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "bogustaskid";
            try {
                r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).get(JSONObject.class);
                Assert.fail((String)"should have thrown exception on invalid uri");
            }
            catch (UniformInterfaceException ue) {
                ClientResponse response = ue.getResponse();
                Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: TaskId string : bogustaskid is not properly formed", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdNonExist() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_m_000000";
            try {
                r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).get(JSONObject.class);
                Assert.fail((String)"should have thrown exception on invalid uri");
            }
            catch (UniformInterfaceException ue) {
                ClientResponse response = ue.getResponse();
                Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: task not found with id task_0_0000_m_000000", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_d_000000";
            try {
                r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).get(JSONObject.class);
                Assert.fail((String)"should have thrown exception on invalid uri");
            }
            catch (UniformInterfaceException ue) {
                ClientResponse response = ue.getResponse();
                Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: Bad TaskType identifier. TaskId string : task_0_0000_d_000000 is not properly formed.", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid2() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0000_m_000000";
            try {
                r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).get(JSONObject.class);
                Assert.fail((String)"should have thrown exception on invalid uri");
            }
            catch (UniformInterfaceException ue) {
                ClientResponse response = ue.getResponse();
                Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: TaskId string : task_0000_m_000000 is not properly formed", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdInvalid3() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            String tid = "task_0_0000_m";
            try {
                r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).get(JSONObject.class);
                Assert.fail((String)"should have thrown exception on invalid uri");
            }
            catch (UniformInterfaceException ue) {
                ClientResponse response = ue.getResponse();
                Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: TaskId string : task_0_0000_m is not properly formed", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
            }
        }
    }

    @Test
    public void testTaskIdXML() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).accept(new String[]{"application/xml"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
                String xml = (String)response.getEntity(String.class);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList nodes = dom.getElementsByTagName("task");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element = (Element)nodes.item(i);
                    this.verifyHsSingleTaskXML(element, task);
                }
            }
        }
    }

    public void verifyHsSingleTask(JSONObject info, Task task) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)9L, (long)info.length());
        this.verifyTaskGeneric(task, info.getString("id"), info.getString("state"), info.getString("type"), info.getString("successfulAttempt"), info.getLong("startTime"), info.getLong("finishTime"), info.getLong("elapsedTime"), (float)info.getDouble("progress"));
    }

    public void verifyHsTask(JSONArray arr, Job job, String type) throws JSONException {
        for (Task task : job.getTasks().values()) {
            TaskId id = task.getID();
            String tid = MRApps.toString((TaskId)id);
            Boolean found = false;
            if (type == null || task.getType() != MRApps.taskType((String)type)) continue;
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject info = arr.getJSONObject(i);
                if (!tid.matches(info.getString("id"))) continue;
                found = true;
                this.verifyHsSingleTask(info, task);
            }
            Assert.assertTrue((String)("task with id: " + tid + " not in web service output"), (boolean)found);
        }
    }

    public void verifyTaskGeneric(Task task, String id, String state, String type, String successfulAttempt, long startTime, long finishTime, long elapsedTime, float progress) {
        TaskId taskid = task.getID();
        String tid = MRApps.toString((TaskId)taskid);
        TaskReport report = task.getReport();
        WebServicesTestUtils.checkStringMatch((String)"id", (String)tid, (String)id);
        WebServicesTestUtils.checkStringMatch((String)"type", (String)task.getType().toString(), (String)type);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)report.getTaskState().toString(), (String)state);
        Assert.assertNotNull((String)"successfulAttempt null", (Object)successfulAttempt);
        Assert.assertEquals((String)"startTime wrong", (long)report.getStartTime(), (long)startTime);
        Assert.assertEquals((String)"finishTime wrong", (long)report.getFinishTime(), (long)finishTime);
        Assert.assertEquals((String)"elapsedTime wrong", (long)(finishTime - startTime), (long)elapsedTime);
        Assert.assertEquals((String)"progress wrong", (float)(report.getProgress() * 100.0f), (float)progress, (float)0.001f);
    }

    public void verifyHsSingleTaskXML(Element element, Task task) {
        this.verifyTaskGeneric(task, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"type"), WebServicesTestUtils.getXmlString((Element)element, (String)"successfulAttempt"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"progress"));
    }

    public void verifyHsTaskXML(NodeList nodes, Job job) {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodes.getLength());
        for (Task task : job.getTasks().values()) {
            TaskId id = task.getID();
            String tid = MRApps.toString((TaskId)id);
            Boolean found = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if (!tid.matches(WebServicesTestUtils.getXmlString((Element)element, (String)"id"))) continue;
                found = true;
                this.verifyHsSingleTaskXML(element, task);
            }
            Assert.assertTrue((String)("task with id: " + tid + " not in web service output"), (boolean)found);
        }
    }

    @Test
    public void testTaskIdCounters() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").accept(new String[]{"application/json"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyHsJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testTaskIdCountersSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters/").accept(new String[]{"application/json"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyHsJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testTaskIdCountersDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                JSONObject info = json.getJSONObject("jobTaskCounters");
                this.verifyHsJobTaskCounters(info, task);
            }
        }
    }

    @Test
    public void testJobTaskCountersXML() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("counters").accept(new String[]{"application/xml"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
                String xml = (String)response.getEntity(String.class);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList info = dom.getElementsByTagName("jobTaskCounters");
                this.verifyHsTaskCountersXML(info, task);
            }
        }
    }

    public void verifyHsJobTaskCounters(JSONObject info, Task task) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskId)task.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("taskCounterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assert.assertTrue((String)"name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                long value = counter.getLong("value");
                Assert.assertTrue((String)"value  >= 0", (value >= 0L ? 1 : 0) != 0);
            }
        }
    }

    public void verifyHsTaskCountersXML(NodeList nodes, Task task) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskId)task.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("taskCounterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)counters);
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assert.assertTrue((String)"counter name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                    long value = WebServicesTestUtils.getXmlLong((Element)counter, (String)"value");
                    Assert.assertTrue((String)"value not >= 0", (value >= 0L ? 1 : 0) != 0);
                }
            }
        }
    }

    static /* synthetic */ MockHistoryContext access$002(MockHistoryContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ HsWebApp access$102(HsWebApp x0) {
        webApp = x0;
        return webApp;
    }

    static /* synthetic */ HsWebApp access$100() {
        return webApp;
    }

    static /* synthetic */ MockHistoryContext access$000() {
        return appContext;
    }

    static /* synthetic */ Configuration access$200() {
        return conf;
    }

    static /* synthetic */ Injector access$300(TestHsWebServicesTasks x0) {
        return x0.injector;
    }
}

