/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.Collection;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobListCache {
    @Test(timeout=1000L)
    public void testAddExisting() {
        HistoryFileManager.JobListCache cache = new HistoryFileManager.JobListCache(2, 1000L);
        JobId jobId = MRBuilderUtils.newJobId((long)1L, (int)1, (int)1);
        HistoryFileManager.HistoryFileInfo fileInfo = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)fileInfo.getJobId()).thenReturn((Object)jobId);
        cache.addIfAbsent(fileInfo);
        cache.addIfAbsent(fileInfo);
        Assert.assertEquals((String)"Incorrect number of cache entries", (long)1L, (long)cache.values().size());
    }

    @Test(timeout=5000L)
    public void testEviction() throws InterruptedException {
        int maxSize = 2;
        HistoryFileManager.JobListCache cache = new HistoryFileManager.JobListCache(maxSize, 1000L);
        JobId jobId1 = MRBuilderUtils.newJobId((long)1L, (int)1, (int)1);
        HistoryFileManager.HistoryFileInfo fileInfo1 = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)fileInfo1.getJobId()).thenReturn((Object)jobId1);
        JobId jobId2 = MRBuilderUtils.newJobId((long)2L, (int)2, (int)2);
        HistoryFileManager.HistoryFileInfo fileInfo2 = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)fileInfo2.getJobId()).thenReturn((Object)jobId2);
        JobId jobId3 = MRBuilderUtils.newJobId((long)3L, (int)3, (int)3);
        HistoryFileManager.HistoryFileInfo fileInfo3 = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)fileInfo3.getJobId()).thenReturn((Object)jobId3);
        cache.addIfAbsent(fileInfo1);
        cache.addIfAbsent(fileInfo2);
        cache.addIfAbsent(fileInfo3);
        for (int i = 0; i < 9; ++i) {
            Collection values = cache.values();
            if (values.size() <= maxSize) {
                Assert.assertFalse((String)"fileInfo1 should have been evicted", (boolean)values.contains(fileInfo1));
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail((String)"JobListCache didn't delete the extra entry");
    }
}

